/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="replace")
public class ReplaceInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReplaceInterceptor.class);
    private String jsonPath;
    private String with;

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc.getRequestContentType(), exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc.getResponseContentType(), exc.getResponse());
    }

    private Outcome handleInternal(String contentType, Message msg) {
        if (contentType.equals("application/json")) {
            msg.setBodyContent(this.replaceWithJsonPath(msg, this.jsonPath, this.with).getBytes());
        }
        return Outcome.CONTINUE;
    }

    String replaceWithJsonPath(Message msg, String jsonPath, String replacement) {
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(msg.getBodyAsStringDecoded());
        document = JsonPath.parse((Object)document).set(jsonPath, (Object)replacement, new Predicate[0]).json();
        return Configuration.defaultConfiguration().jsonProvider().toJson(document);
    }

    @MCAttribute
    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    @MCAttribute
    public void setWith(String with) {
        this.with = with;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }

    public String getWith() {
        return this.with;
    }
}

