/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.interceptor.jwt.JWTException;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWebToken {
    private static final Logger log = LoggerFactory.getLogger((String)JsonWebToken.class.getName());
    private final Header header;
    private final Payload payload;
    public static final String ERROR_MALFORMED_COMPACT_SERIALIZATION = "JWTs compact serialization not valid";
    public static final String ERROR_DECODED_HEADER_NOT_JSON = "JWT header is not valid JSON";

    public static String ERROR_JWT_VALUE_NOT_PRESENT(String key) {
        return "JWT does not contain '" + key + "'";
    }

    public JsonWebToken(String jwt) throws JWTException {
        String[] chunks = jwt.split("\\.");
        if (chunks.length < 3) {
            log.warn("Less than 3 parts in JWT header: {}", (Object)jwt);
            throw new JWTException(ERROR_MALFORMED_COMPACT_SERIALIZATION);
        }
        Base64.Decoder decoder = Base64.getUrlDecoder();
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.header = new Header((Map)mapper.readValue(decoder.decode(chunks[0]), Map.class));
            this.payload = new Payload((Map)mapper.readValue(decoder.decode(chunks[1]), Map.class));
        }
        catch (IOException e) {
            throw new JWTException(ERROR_DECODED_HEADER_NOT_JSON);
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public static class Header
    extends AbstractJwtSubHolder {
        protected Header(Map<String, Object> data) {
            super(data);
        }

        public String kid() throws JWTException {
            return this.get("kid").toString();
        }
    }

    public static class Payload
    extends AbstractJwtSubHolder {
        protected Payload(Map<String, Object> data) {
            super(data);
        }
    }

    public static abstract class AbstractJwtSubHolder {
        private final Map<String, Object> data;

        protected AbstractJwtSubHolder(Map<String, Object> data) {
            this.data = data;
        }

        public Object get(String key) throws JWTException {
            if (this.data.containsKey(key)) {
                return this.data.get(key);
            }
            throw new JWTException(JsonWebToken.ERROR_JWT_VALUE_NOT_PRESENT(key));
        }
    }
}

