/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.session.JwtSessionManager;
import com.predic8.membrane.core.util.ConfigurationException;
import java.io.IOException;
import java.security.Key;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="jwtSign")
public class JwtSignInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JwtSignInterceptor.class);
    private JwtSessionManager.Jwk jwk;
    private RsaJsonWebKey rsaJsonWebKey;
    private int expiryTime = 300;
    private final ObjectMapper om = new ObjectMapper();

    @Override
    public void init() {
        super.init();
        try {
            this.rsaJsonWebKey = new RsaJsonWebKey(JsonUtil.parseJson((String)this.jwk.get(this.router.getResolverMap(), this.router.getBaseLocation())));
        }
        catch (JoseException e) {
            throw new ConfigurationException("Cannot create RSA JSON Web Key", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot parse JWK", e);
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.RESPONSE);
    }

    private Outcome handleInternal(Exchange exc, Interceptor.Flow flow) {
        try {
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(this.prepareJwtPayload(exc.getMessage(flow)));
            jws.setKey((Key)this.rsaJsonWebKey.getRsaPrivateKey());
            jws.setAlgorithmHeaderValue("RS256");
            jws.setKeyIdHeaderValue(this.rsaJsonWebKey.getKeyId());
            exc.getMessage(flow).setBodyContent(jws.getCompactSerialization().getBytes());
            return Outcome.CONTINUE;
        }
        catch (Exception e) {
            log.error("Error during attempt to sign JWT payload", (Throwable)e);
            ProblemDetails.security(this.router.isProduction(), this.getDisplayName()).addSubSee("crypto").detail("Error during attempt to sign JWT payload.").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    private String prepareJwtPayload(Message msg) throws IOException {
        ObjectNode jsonBody = (ObjectNode)this.om.readTree(msg.getBodyAsStream());
        long epoch = System.currentTimeMillis() / 1000L;
        jsonBody.put("iat", epoch);
        jsonBody.put("exp", epoch + (long)this.expiryTime);
        return jsonBody.toString();
    }

    public JwtSessionManager.Jwk getJwk() {
        return this.jwk;
    }

    @MCChildElement
    public void setJwk(JwtSessionManager.Jwk jwk) {
        this.jwk = jwk;
    }

    public int getExpiryTime() {
        return this.expiryTime;
    }

    @MCAttribute
    public void setExpiryTime(int expiryTime) {
        this.expiryTime = expiryTime;
    }
}

