/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.kubernetes;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.kubernetes.model.AdmissionResponse;
import com.predic8.membrane.core.interceptor.kubernetes.model.AdmissionReview;
import com.predic8.membrane.core.interceptor.kubernetes.model.JSONValidatorError;
import com.predic8.membrane.core.interceptor.kubernetes.model.ResponseStatus;
import com.predic8.membrane.core.interceptor.schemavalidation.JSONSchemaValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.MessageValidator;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="kubernetesValidation")
public class KubernetesValidationInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)KubernetesValidationInterceptor.class.getName());
    private ResolverMap resourceResolver;
    private List<String> resources;
    private final ConcurrentMap<String, MessageValidator> validators = new ConcurrentHashMap<String, MessageValidator>();
    private List<String> namespaces = ImmutableList.of((Object)"membrane-soa");

    @Override
    public void init() {
        super.init();
        this.resourceResolver = this.router.getResolverMap();
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            if (exc.getRequest().isBodyEmpty()) {
                return Outcome.CONTINUE;
            }
            ObjectMapper mapper = new ObjectMapper();
            AdmissionReview review = (AdmissionReview)mapper.readValue((Reader)new BufferedReader(new InputStreamReader(exc.getRequest().getBodyAsStreamDecoded(), Charset.forName(exc.getRequest().getCharset()))), AdmissionReview.class);
            Map<String, Object> object = review.getRequest().getObject();
            if (object != null) {
                String requestKind = (String)object.get("kind");
                MessageValidator validator = this.validators.computeIfAbsent(requestKind.toLowerCase(), schema -> new JSONSchemaValidator(this.resourceResolver, "classpath:/com/predic8/membrane/core/config/kubernetes/" + schema + ".schema.json", null));
                validator.validateMessage(exc, Interceptor.Flow.REQUEST);
            }
            this.setExchangeResponse(exc, mapper, review);
            return Outcome.RETURN;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).component(this.getDisplayName()).detail("Error handling request!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    private void setExchangeResponse(Exchange exc, ObjectMapper mapper, AdmissionReview review) throws Exception {
        AdmissionResponse response = new AdmissionResponse(review.getRequest().getUid());
        review.setResponse(response);
        if (exc.getResponse() == null) {
            response.setAllowed(true);
        } else {
            response.setAllowed(false);
            List<String> errors = ((JSONValidatorError)mapper.readValue(exc.getResponse().getBody().toString(), JSONValidatorError.class)).getErrors();
            response.setStatus(new ResponseStatus(String.join((CharSequence)", ", errors)));
        }
        review.setRequest(null);
        exc.setResponse(Response.ok(mapper.writeValueAsString((Object)review)).build());
    }

    @MCAttribute
    public void setResources(String resources) {
        this.resources = Arrays.asList(resources.split(","));
    }

    public String getResources() {
        return String.join((CharSequence)",", this.resources);
    }

    public List<String> getResourcesList() {
        return this.resources;
    }

    public List<String> getNamespacesList() {
        return this.namespaces;
    }

    public String getNamespaces() {
        return String.join((CharSequence)",", this.namespaces);
    }

    @MCAttribute
    public void setNamespaces(String namespaces) {
        this.namespaces = Arrays.asList(namespaces.split(","));
    }
}

