/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.lang;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.lang.Polyglot;
import com.predic8.membrane.core.lang.ExchangeExpression;
import com.predic8.membrane.core.util.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLanguageInterceptor
extends AbstractInterceptor
implements Polyglot {
    private static final Logger log = LoggerFactory.getLogger(AbstractLanguageInterceptor.class);
    protected ExchangeExpression.Language language = ExchangeExpression.Language.SPEL;

    AbstractLanguageInterceptor() {
    }

    public String getLanguage() {
        return this.language.name();
    }

    @Override
    @MCAttribute
    public void setLanguage(String language) {
        try {
            this.language = ExchangeExpression.Language.valueOf(language.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("Language {} is not supported by {} use one of {}", new Object[]{language, this.getDisplayName(), ExchangeExpression.Language.values()});
            throw new ConfigurationException("Wrong Language\n\nLanguage %s is not supported as an expression language for %s.\n".formatted(language, this.getDisplayName()));
        }
    }
}

