/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.lang;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.lang.AbstractExchangeExpressionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSetterInterceptor
extends AbstractExchangeExpressionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSetterInterceptor.class);
    private boolean failOnError = true;
    protected String fieldName;
    protected boolean ifAbsent;

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.RESPONSE);
    }

    private Outcome handleInternal(Exchange exchange, Interceptor.Flow flow) {
        if (!this.shouldSetValue(exchange, flow)) {
            return Outcome.CONTINUE;
        }
        try {
            this.setValue(exchange, flow, this.exchangeExpression.evaluate(exchange, flow, this.getExpressionReturnType()));
        }
        catch (Exception e) {
            log.error("While evaluating expression {} for field {}: {}", new Object[]{this.expression, this.fieldName, e.getMessage()});
            if (this.failOnError) {
                ProblemDetails.internal(this.getRouter().isProduction(), this.getDisplayName()).title("Error evaluating expression!").internal("field", this.fieldName).internal("value", this.expression).exception(e).stacktrace(false).buildAndSetResponse(exchange);
                return Outcome.ABORT;
            }
            log.info("Error evaluating {} but 'FailOnError' is false therefore ignoring. Exception :{}", (Object)this.expression, (Object)e);
        }
        return Outcome.CONTINUE;
    }

    protected abstract Class<?> getExpressionReturnType();

    protected abstract boolean shouldSetValue(Exchange var1, Interceptor.Flow var2);

    protected abstract void setValue(Exchange var1, Interceptor.Flow var2, Object var3);

    @MCAttribute
    public void setIfAbsent(boolean ifAbsent) {
        this.ifAbsent = ifAbsent;
    }

    public boolean getIfAbsent() {
        return this.ifAbsent;
    }

    @MCAttribute(attributeName="name")
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @MCAttribute
    public void setValue(String value) {
        this.expression = value;
    }

    public String getValue() {
        return this.expression;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @MCAttribute
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

