/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.lang;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.lang.AbstractSetterInterceptor;

@MCElement(name="setHeader")
public class SetHeaderInterceptor
extends AbstractSetterInterceptor {
    @Override
    protected Class<?> getExpressionReturnType() {
        return String.class;
    }

    @Override
    protected boolean shouldSetValue(Exchange exc, Interceptor.Flow flow) {
        if (this.ifAbsent) {
            return !exc.getMessage(flow).getHeader().contains(this.fieldName);
        }
        return true;
    }

    @Override
    protected void setValue(Exchange exc, Interceptor.Flow flow, Object value) {
        exc.getMessage(flow).getHeader().setValue(this.fieldName, value.toString());
    }

    @Override
    public String getDisplayName() {
        return "setHeader";
    }

    @Override
    public String getShortDescription() {
        return "Sets the value of the HTTP header '%s' to the expression: %s.".formatted(this.fieldName, this.expression);
    }
}

