/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.lang;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.lang.AbstractSetterInterceptor;

@MCElement(name="setProperty")
public class SetPropertyInterceptor
extends AbstractSetterInterceptor {
    @Override
    protected Class<?> getExpressionReturnType() {
        return Object.class;
    }

    @Override
    protected boolean shouldSetValue(Exchange exchange, Interceptor.Flow ignored) {
        if (this.ifAbsent) {
            return exchange.getProperty(this.fieldName) == null;
        }
        return true;
    }

    @Override
    protected void setValue(Exchange exchange, Interceptor.Flow flow, Object evaluatedValue) {
        exchange.setProperty(this.fieldName, evaluatedValue);
    }

    @Override
    public String getDisplayName() {
        return "setProperty";
    }

    @Override
    public String getShortDescription() {
        return "Sets the value of the exchange property '%s' to %s.".formatted(this.fieldName, this.expression);
    }
}

