/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.log;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.log.AccessLogInterceptorService;
import com.predic8.membrane.core.interceptor.log.AdditionalVariable;
import java.util.ArrayList;
import java.util.List;

@MCElement(name="accessLog")
public class AccessLogInterceptor
extends AbstractInterceptor {
    private List<AdditionalVariable> additionalVariables = new ArrayList<AdditionalVariable>();
    private String defaultValue = "-";
    private String dateTimePattern = "dd/MM/yyyy:HH:mm:ss Z";
    private boolean excludePayloadSize = false;
    private AccessLogInterceptorService accessLogInterceptorService;

    public AccessLogInterceptor() {
        this.name = "access log";
    }

    @Override
    public String getShortDescription() {
        return "SpEL expression based exchange data logging through Log4j appender.";
    }

    @Override
    public void init() {
        super.init();
        this.accessLogInterceptorService = new AccessLogInterceptorService(this.dateTimePattern, this.defaultValue, this.additionalVariables, this.excludePayloadSize);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        this.accessLogInterceptorService.handleAccessLogging(exc);
        return Outcome.CONTINUE;
    }

    @Override
    public void handleAbort(Exchange exc) {
        this.accessLogInterceptorService.handleAccessLogging(exc);
    }

    public List<AdditionalVariable> getAdditionalPatternList() {
        return this.additionalVariables;
    }

    @MCChildElement
    public void setAdditionalPatternList(List<AdditionalVariable> additionalVariableList) {
        this.additionalVariables = additionalVariableList;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @MCAttribute
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    @MCAttribute
    public void setDateTimePattern(String dateTimePattern) {
        this.dateTimePattern = dateTimePattern;
    }

    public boolean isExcludePayloadSize() {
        return this.excludePayloadSize;
    }

    @MCAttribute
    public void setExcludePayloadSize(boolean excludePayloadSize) {
        this.excludePayloadSize = excludePayloadSize;
    }
}

