/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.log;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.log.AccessLogInterceptor;
import com.predic8.membrane.core.interceptor.log.AdditionalVariable;
import com.predic8.membrane.core.lang.spel.SpELExchangeEvaluationContext;
import com.predic8.membrane.core.util.TextUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.expression.EvaluationContext;

public class AccessLogInterceptorService {
    private static final Logger log = LoggerFactory.getLogger(AccessLogInterceptor.class);
    private final SimpleDateFormat dateTimeFormat;
    private final String defaultValue;
    private final List<AdditionalVariable> additionalVariables;
    private final boolean excludePayloadSize;

    public AccessLogInterceptorService(String dateTimePattern, String defaultValue, List<AdditionalVariable> additionalVariables, boolean excludePayloadSize) {
        this.dateTimeFormat = new SimpleDateFormat(dateTimePattern);
        this.defaultValue = defaultValue;
        this.additionalVariables = additionalVariables;
        this.excludePayloadSize = excludePayloadSize;
    }

    public void handleAccessLogging(Exchange exc) {
        MDC.setContextMap(this.generateMDCMap(exc));
        log.info("");
        MDC.clear();
    }

    private Map<String, String> generateMDCMap(Exchange exc) {
        HashMap<String, String> ctx = new HashMap<String, String>(this.getBaseProperties(exc));
        ctx.putAll(this.getTimeProperties(exc));
        ctx.putAll(this.getTimeProperties2(exc));
        if (!this.excludePayloadSize) {
            ctx.put("req.payload.size", this.safe(this.getPayLoadSize(exc.getRequest())));
            ctx.put("res.payload.size", this.safe(this.getPayLoadSize(exc.getResponse())));
        }
        ctx.putAll(this.getAdditionalProvidedPattern(exc));
        return ctx;
    }

    private Map<String, String> getTimeProperties2(Exchange exc) {
        return Map.of("time.diff.received.raw", this.safe(() -> exc.getTimeResReceived() - exc.getTimeReqReceived()), "time.diff.received.format", this.convert(this.safe(() -> exc.getTimeResReceived() - exc.getTimeReqReceived())), "time.diff.sent.raw", this.safe(() -> exc.getTimeResSent() - exc.getTimeReqSent()), "time.diff.sent.format", this.convert(this.safe(() -> exc.getTimeResSent() - exc.getTimeReqSent())));
    }

    private Map<String, String> getTimeProperties(Exchange exc) {
        return Map.of("time.req.received.raw", this.safe(exc::getTimeReqReceived), "time.req.received.format", this.convert(this.safe(exc::getTimeReqReceived)), "time.req.sent.raw", this.safe(exc::getTimeReqSent), "time.req.sent.format", this.convert(this.safe(exc::getTimeReqSent)), "time.res.received.raw", this.safe(exc::getTimeResReceived), "time.res.received.format", this.convert(this.safe(exc::getTimeResReceived)), "time.res.sent.raw", this.safe(exc::getTimeResSent), "time.res.sent.format", this.convert(this.safe(exc::getTimeResSent)));
    }

    private Map<String, String> getBaseProperties(Exchange exc) {
        return Map.of("ip", this.safe(exc::getRemoteAddrIp), "host", this.safe(exc::getOriginalHostHeaderHost), "port", this.safe(exc::getOriginalHostHeaderPort), "uri", this.safe(exc::getOriginalRequestUri), "proto", this.safe(() -> exc.getRequest().getHeader().getFirstValue("x-forwarded-proto").toUpperCase()), "http.version", this.safe(() -> exc.getRequest().getVersion()), "http.method", this.safe(() -> exc.getRequest().getMethod()), "statusCode", this.safe(() -> exc.getResponse().getStatusCode()));
    }

    private Supplier<Object> getPayLoadSize(Message msg) {
        return () -> {
            try {
                return msg.getBody().getLength();
            }
            catch (IOException e) {
                return this.defaultValue;
            }
        };
    }

    private String safe(Supplier<Object> access) {
        return this.safe(access, this.defaultValue);
    }

    private String safe(Supplier<Object> access, String defaultValue) {
        try {
            return TextUtil.escapeQuotes(String.valueOf(access.get()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private Map<String, String> getAdditionalProvidedPattern(Exchange exc) {
        if (this.additionalVariables.isEmpty()) {
            return Map.of();
        }
        return this.additionalVariables.stream().map(this.additionalPatternToMapEntry(exc)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Function<AdditionalVariable, AbstractMap.SimpleEntry<String, String>> additionalPatternToMapEntry(Exchange exc) {
        return additionalPattern -> new AbstractMap.SimpleEntry<String, String>(additionalPattern.getName(), this.safe(() -> additionalPattern.getExpression().getValue((EvaluationContext)new SpELExchangeEvaluationContext(exc, Interceptor.Flow.REQUEST)), additionalPattern.getDefaultValue()));
    }

    private String convert(String timestamp) {
        return this.dateTimeFormat.format(Long.parseLong(timestamp));
    }
}

