/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.log;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.lang.AbstractExchangeExpressionInterceptor;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import java.io.IOException;
import org.slf4j.LoggerFactory;

@MCElement(name="log")
public class LogInterceptor
extends AbstractExchangeExpressionInterceptor {
    private Level level = Level.INFO;
    private String category = LogInterceptor.class.getName();
    private String label = "";
    private boolean body = true;

    public LogInterceptor() {
        this.name = "log";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        this.logMessage(exc, Interceptor.Flow.REQUEST);
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        this.logMessage(exc, Interceptor.Flow.RESPONSE);
        return Outcome.CONTINUE;
    }

    @Override
    public void handleAbort(Exchange exc) {
        try {
            this.writeLog("==== Response(Exchange aborted) %s ===".formatted(this.label));
            this.logMessage(exc, Interceptor.Flow.ABORT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isBody() {
        return this.body;
    }

    @MCAttribute
    public void setBody(boolean body) {
        this.body = body;
    }

    public Level getLevel() {
        return this.level;
    }

    @MCAttribute
    public void setLevel(Level level) {
        this.level = level;
    }

    private void logMessage(Exchange exc, Interceptor.Flow flow) {
        if (this.getMessage() != null && !this.getMessage().isEmpty()) {
            try {
                this.writeLog(this.exchangeExpression.evaluate(exc, flow, String.class));
            }
            catch (ExchangeExpressionException e) {
                LoggerFactory.getLogger((String)this.category).warn("Problems evaluating {} expression: {}", (Object)this.getMessage(), (Object)e.getMessage());
            }
            return;
        }
        this.writeLog("==== %s %s ===".formatted(new Object[]{flow, this.label}));
        Message msg = exc.getMessage(flow);
        if (msg == null) {
            return;
        }
        this.writeLog(msg.getStartLine());
        this.writeLog("\nHeaders:\n" + String.valueOf(msg.getHeader()));
        try {
            if (!this.body || msg.isBodyEmpty()) {
                return;
            }
        }
        catch (IOException e) {
            this.writeLog("Error accessing body: " + e.getMessage());
            return;
        }
        String mt = msg.getHeader().getContentType();
        if (MimeType.isJson(mt) || MimeType.isXML(mt) || MimeType.isText(mt)) {
            this.writeLog(LogInterceptor.dumpBody(msg));
        }
    }

    private static String dumpBody(Message msg) {
        return "Body:\n%s\n".formatted(msg.getBodyAsStringDecoded());
    }

    private void writeLog(String msg) {
        switch (this.level.ordinal()) {
            case 0: {
                LoggerFactory.getLogger((String)this.category).trace(msg);
                break;
            }
            case 1: {
                LoggerFactory.getLogger((String)this.category).debug(msg);
                break;
            }
            case 2: {
                LoggerFactory.getLogger((String)this.category).info(msg);
                break;
            }
            case 3: {
                LoggerFactory.getLogger((String)this.category).warn(msg);
                break;
            }
            case 4: 
            case 5: {
                LoggerFactory.getLogger((String)this.category).error(msg);
            }
        }
    }

    public String getCategory() {
        return this.category;
    }

    @MCAttribute
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getShortDescription() {
        return "Logs the " + (this.body ? "headers of " : "") + "requests and responses using Log4J's " + this.level.toString() + " level.";
    }

    public String getLabel() {
        return this.label;
    }

    @MCAttribute
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDisplayName() {
        return "log";
    }

    @MCAttribute
    public void setMessage(String message) {
        this.expression = message;
    }

    public String getMessage() {
        return this.expression;
    }

    public boolean isHeaderOnly() {
        return false;
    }

    @MCAttribute
    public void setHeaderOnly(boolean headerOnly) {
        LoggerFactory.getLogger(this.getClass()).warn("Configuration option `headerOnly` is not supported anymore. Use `body` instead.");
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

