/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ntlm;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.ntlm.NTLMRetriever;

@MCElement(name="headerRetriever", topLevel=false)
public class HeaderNTLMRetriever
implements NTLMRetriever {
    String userHeaderName;
    String passwordHeaderName;
    String domainHeaderName;
    String workstationHeaderName;

    public HeaderNTLMRetriever() {
    }

    public HeaderNTLMRetriever(String userHeaderName, String passwordHeaderName, String domainHeaderName, String workstationHeaderName) {
        if (userHeaderName == null || userHeaderName.isEmpty()) {
            throw new RuntimeException("userHeaderName attribute cannot be null or empty");
        }
        if (passwordHeaderName == null || passwordHeaderName.isEmpty()) {
            throw new RuntimeException("passwordHeaderName attribute cannot be null or empty");
        }
        this.userHeaderName = userHeaderName;
        this.passwordHeaderName = passwordHeaderName;
        this.domainHeaderName = domainHeaderName;
        this.workstationHeaderName = workstationHeaderName;
    }

    @Override
    public String fetchUsername(Exchange exc) {
        return exc.getRequest().getHeader().getFirstValue(this.userHeaderName);
    }

    @Override
    public String fetchPassword(Exchange exc) {
        return exc.getRequest().getHeader().getFirstValue(this.passwordHeaderName);
    }

    @Override
    public String fetchDomain(Exchange exc) {
        return exc.getRequest().getHeader().getFirstValue(this.domainHeaderName);
    }

    @Override
    public String fetchWorkstation(Exchange exc) {
        return exc.getRequest().getHeader().getFirstValue(this.workstationHeaderName);
    }

    public String getUserHeaderName() {
        return this.userHeaderName;
    }

    @MCAttribute(attributeName="user")
    public void setUserHeaderName(String userHeaderName) {
        this.userHeaderName = userHeaderName;
    }

    public String getPasswordHeaderName() {
        return this.passwordHeaderName;
    }

    @MCAttribute(attributeName="pass")
    public void setPasswordHeaderName(String passwordHeaderName) {
        this.passwordHeaderName = passwordHeaderName;
    }

    public String getDomainHeaderName() {
        return this.domainHeaderName;
    }

    @MCAttribute(attributeName="domain")
    public void setDomainHeaderName(String domainHeaderName) {
        this.domainHeaderName = domainHeaderName;
    }

    public String getWorkstationHeaderName() {
        return this.workstationHeaderName;
    }

    @MCAttribute(attributeName="workstation")
    public void setWorkstationHeaderName(String workstationHeaderName) {
        this.workstationHeaderName = workstationHeaderName;
    }
}

