/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ntlm;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.ntlm.HeaderNTLMRetriever;
import com.predic8.membrane.core.interceptor.ntlm.NTLMRetriever;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.transport.http.HttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineTrampoline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="ntlm")
public class NtlmInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NtlmInterceptor.class);
    NTLMRetriever NTLMRetriever;
    String userHeaderName;
    String passwordHeaderName;
    String domainHeaderName;
    String workstationHeaderName;
    private HttpClient httpClient;

    public NtlmInterceptor() {
        this.name = "ntlm authentication";
    }

    @Override
    public String getShortDescription() {
        return "Secures APIs through NTLM.";
    }

    @Override
    public void init() {
        super.init();
        if (this.NTLMRetriever == null) {
            this.NTLMRetriever = new HeaderNTLMRetriever(this.userHeaderName, this.passwordHeaderName, this.domainHeaderName, this.workstationHeaderName);
        }
        this.httpClient = this.router.getHttpClientFactory().createClient(null);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        Exchange authenticationResult;
        String originalRequestUrl = this.buildRequestUrl(exc);
        Connection stableConnection = exc.getTargetConnection();
        if (exc.getResponse().getHeader().getWwwAuthenticate() == null) {
            return Outcome.CONTINUE;
        }
        List<HeaderField> wwwAuthenticate = exc.getResponse().getHeader().getValues(new HeaderName("WWW-Authenticate"));
        if (wwwAuthenticate.stream().noneMatch(h -> h.getValue().equalsIgnoreCase("ntlm"))) {
            return Outcome.CONTINUE;
        }
        this.prepareStreamByEmptyingIt(exc);
        String user = this.getNTLMRetriever().fetchUsername(exc);
        String pass = this.getNTLMRetriever().fetchPassword(exc);
        if (user == null || pass == null) {
            exc.setResponse(Response.unauthorized().header("WWW-Authenticate", "Realm=ntlm").build());
            return Outcome.RETURN;
        }
        String domain = this.getNTLMRetriever().fetchDomain(exc) != null ? this.getNTLMRetriever().fetchDomain(exc) : null;
        String workstation = this.getNTLMRetriever().fetchWorkstation(exc) != null ? this.getNTLMRetriever().fetchWorkstation(exc) : null;
        try {
            authenticationResult = this.authenticate(stableConnection, originalRequestUrl, user, pass, domain, workstation);
        }
        catch (Exception e) {
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not authenticate!").internal("domain", domain).internal("workstation", workstation).internal("originalRequestUrl", originalRequestUrl).exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        exc.setResponse(authenticationResult.getResponse());
        exc.setTargetConnection(stableConnection);
        return Outcome.CONTINUE;
    }

    private Exchange authenticate(Connection stableConnection, String originalRequestUrl, String user, String pass, String domain, String workstation) throws Exception {
        Exchange resT1 = this.httpClient.call(this.createT1MessageRequest(stableConnection, originalRequestUrl));
        this.prepareStreamByEmptyingIt(resT1);
        return this.httpClient.call(this.createT3MessageRequest(stableConnection, originalRequestUrl, user, pass, domain, workstation, resT1));
    }

    private Exchange createT3MessageRequest(Connection stableConnection, String originalRequestUrl, String user, String pass, String domain, String workstation, Exchange resT1) throws URISyntaxException, NTLMEngineException {
        Exchange reqT3 = new Request.Builder().get(originalRequestUrl).header("Authorization", "NTLM " + NTLMEngineTrampoline.getResponseFor(this.getT2Payload(resT1), user, pass, workstation, domain)).buildExchange();
        reqT3.getRequest().getHeader().add("Connection", "keep-alive");
        reqT3.setTargetConnection(stableConnection);
        return reqT3;
    }

    private Exchange createT1MessageRequest(Connection stableConnection, String originalRequestUrl) throws URISyntaxException, NTLMEngineException {
        Exchange reqT1 = new Request.Builder().get(originalRequestUrl).header("Authorization", "NTLM " + NTLMEngineTrampoline.getResponseFor(null, null, null, null, null)).buildExchange();
        reqT1.getRequest().getHeader().add("Connection", "keep-alive");
        reqT1.setTargetConnection(stableConnection);
        return reqT1;
    }

    private String getT2Payload(Exchange resT1) {
        return resT1.getResponse().getHeader().getWwwAuthenticate().split(Pattern.quote(" "))[1];
    }

    private String buildRequestUrl(Exchange exc) {
        return (exc.getTargetConnection().getSslProvider() != null ? "https" : "http") + "://" + exc.getRequest().getHeader().getHost() + exc.getRequestURI();
    }

    private void prepareStreamByEmptyingIt(Exchange exc) {
        try {
            exc.getResponse().getBody().getContent();
        }
        catch (IOException e) {
            LOG.warn("", (Throwable)e);
        }
    }

    @MCChildElement(order=1)
    public NtlmInterceptor setNTLMRetriever(NTLMRetriever NTLMRetriever2) {
        this.NTLMRetriever = NTLMRetriever2;
        return this;
    }

    public NTLMRetriever getNTLMRetriever() {
        return this.NTLMRetriever;
    }

    public String getUserHeaderName() {
        return this.userHeaderName;
    }

    @MCAttribute(attributeName="user")
    public void setUserHeaderName(String userHeaderName) {
        this.userHeaderName = userHeaderName;
    }

    public String getPasswordHeaderName() {
        return this.passwordHeaderName;
    }

    @MCAttribute(attributeName="pass")
    public void setPasswordHeaderName(String passwordHeaderName) {
        this.passwordHeaderName = passwordHeaderName;
    }

    public String getDomainHeaderName() {
        return this.domainHeaderName;
    }

    @MCAttribute(attributeName="domain")
    public void setDomainHeaderName(String domainHeaderName) {
        this.domainHeaderName = domainHeaderName;
    }

    public String getWorkstationHeaderName() {
        return this.workstationHeaderName;
    }

    @MCAttribute(attributeName="workstation")
    public void setWorkstationHeaderName(String workstationHeaderName) {
        this.workstationHeaderName = workstationHeaderName;
    }
}

