/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedJsonGenerator
implements AutoCloseable {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final JsonGenerator jsonGenerator;

    public BufferedJsonGenerator() {
        try {
            JsonFactory jsonFactory = new JsonFactory();
            this.jsonGenerator = jsonFactory.createGenerator((OutputStream)this.baos);
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen, as this is in-memory only.", e);
        }
    }

    public JsonGenerator getJsonGenerator() {
        return this.jsonGenerator;
    }

    public String getJson() throws IOException {
        this.jsonGenerator.flush();
        return this.baos.toString();
    }

    public String toString() {
        try {
            return this.getJson();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void close() {
        try {
            this.jsonGenerator.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen, as this is in-memory only.", e);
        }
    }
}

