/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class OAuth2AnswerParameters {
    private String accessToken;
    private String tokenType;
    private String idToken;
    private Map<String, ?> userinfo = new HashMap();
    private String expiration;
    private LocalDateTime receivedAt;
    private String refreshToken;

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public Map<String, ?> getUserinfo() {
        return this.userinfo;
    }

    public void setUserinfo(Map<String, ?> userinfo) {
        this.userinfo = userinfo;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String serialize() throws JsonProcessingException, UnsupportedEncodingException {
        return OAuth2Util.urlencode(OAuth2AnswerParameters.getObjectMapper().writeValueAsString((Object)this));
    }

    public static OAuth2AnswerParameters deserialize(String oauth2answer) throws IOException {
        return (OAuth2AnswerParameters)OAuth2AnswerParameters.getObjectMapper().readValue(OAuth2Util.urldecode(oauth2answer), OAuth2AnswerParameters.class);
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JSR310Module());
        return mapper;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public void setReceivedAt(LocalDateTime receivedAt) {
        this.receivedAt = receivedAt;
    }

    public LocalDateTime getReceivedAt() {
        return this.receivedAt;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String toString() {
        try {
            return OAuth2AnswerParameters.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }
}

