/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

public class OAuth2Statistics {
    private int successfulRequests;
    private int createdAccessTokens;
    private int validatedAccessTokens;
    private int invalidAccessTokens;
    private int codeFlow;
    private int implicitFlow;
    private int passwordFlow;
    private int clientCredentialsFlow;
    private int refreshTokenFlow;
    private StringBuilder builder = new StringBuilder();
    private String newLine = "<br/>";

    public synchronized String toString() {
        this.builder.setLength(0);
        this.builder.append(this.newLine);
        this.writeLine(this.successfulRequests, "Successful requests");
        this.writeLine(this.createdAccessTokens, "Created access tokens");
        this.writeLine(this.validatedAccessTokens, "Valid access tokens");
        this.writeLine(this.invalidAccessTokens, "Invalid access tokens");
        this.writeLine(this.codeFlow, "Code flow requests");
        this.writeLine(this.implicitFlow, "Implicit flow requests");
        this.writeLine(this.passwordFlow, "Password flow requests");
        this.writeLine(this.clientCredentialsFlow, "Client credentials flow requests");
        this.writeLine(this.refreshTokenFlow, "Refresh token requests");
        return this.builder.substring(0, this.builder.length() - this.newLine.length());
    }

    private StringBuilder writeLine(int value, String text) {
        return this.builder.append((String)(value > 0 ? text + ": " + value : "")).append(value > 0 ? this.newLine : "");
    }

    public synchronized void successfulRequest() {
        ++this.successfulRequests;
    }

    public synchronized void accessTokenCreated() {
        ++this.createdAccessTokens;
    }

    public synchronized void accessTokenValid() {
        ++this.validatedAccessTokens;
    }

    public synchronized void accessTokenInvalid() {
        ++this.invalidAccessTokens;
    }

    public synchronized void codeFlow() {
        ++this.codeFlow;
    }

    public synchronized void implicitFlow() {
        ++this.implicitFlow;
    }

    public synchronized void passwordFlow() {
        ++this.passwordFlow;
    }

    public synchronized void clientCredentialsFlow() {
        ++this.clientCredentialsFlow;
    }

    public synchronized void refreshTokenFlow() {
        ++this.refreshTokenFlow;
    }

    public int getSuccessfulRequests() {
        return this.successfulRequests;
    }

    public void setSuccessfulRequests(int successfulRequests) {
        this.successfulRequests = successfulRequests;
    }

    public int getCreatedAccessTokens() {
        return this.createdAccessTokens;
    }

    public void setCreatedAccessTokens(int createdAccessTokens) {
        this.createdAccessTokens = createdAccessTokens;
    }

    public int getValidatedAccessTokens() {
        return this.validatedAccessTokens;
    }

    public void setValidatedAccessTokens(int validatedAccessTokens) {
        this.validatedAccessTokens = validatedAccessTokens;
    }

    public int getInvalidAccessTokens() {
        return this.invalidAccessTokens;
    }

    public void setInvalidAccessTokens(int invalidAccessTokens) {
        this.invalidAccessTokens = invalidAccessTokens;
    }

    public int getCodeFlow() {
        return this.codeFlow;
    }

    public void setCodeFlow(int codeFlow) {
        this.codeFlow = codeFlow;
    }

    public int getImplicitFlow() {
        return this.implicitFlow;
    }

    public void setImplicitFlow(int implicitFlow) {
        this.implicitFlow = implicitFlow;
    }

    public int getPasswordFlow() {
        return this.passwordFlow;
    }

    public void setPasswordFlow(int passwordFlow) {
        this.passwordFlow = passwordFlow;
    }

    public int getClientCredentialsFlow() {
        return this.clientCredentialsFlow;
    }

    public void setClientCredentialsFlow(int clientCredentialsFlow) {
        this.clientCredentialsFlow = clientCredentialsFlow;
    }

    public int getRefreshTokenFlow() {
        return this.refreshTokenFlow;
    }

    public void setRefreshTokenFlow(int refreshTokenFlow) {
        this.refreshTokenFlow = refreshTokenFlow;
    }
}

