/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.oauth2.BufferedJsonGenerator;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SSLableProxy;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class OAuth2Util {
    public static String urlencode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
    }

    public static String urldecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
    }

    public static boolean isOpenIdScope(String scope) {
        if (scope == null) {
            return false;
        }
        return Arrays.asList(scope.split(" ")).contains("openid");
    }

    public static boolean isAbsoluteUri(String uri) {
        return uri.contains("://");
    }

    public static Response createParameterizedJsonErrorResponse(String ... params) throws IOException {
        String json;
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("The number of strings passed as params is not even");
        }
        try (BufferedJsonGenerator bufferedJsonGenerator = new BufferedJsonGenerator();){
            JsonGenerator gen = bufferedJsonGenerator.getJsonGenerator();
            gen.writeStartObject();
            for (int i = 0; i < params.length; i += 2) {
                gen.writeObjectField(params[i], (Object)params[i + 1]);
            }
            gen.writeEndObject();
            json = bufferedJsonGenerator.getJson();
        }
        return Response.badRequest().body(json).contentType("application/json;charset=utf-8").dontCache().build();
    }

    @NotNull
    public static String getPublicURL(Exchange exc) {
        return (OAuth2Util.isHTTPS(exc.getProxy(), OAuth2Util.getxForwardedProto(exc)) ? "https://" : "http://") + exc.getOriginalHostHeader();
    }

    private static boolean isHTTPS(Proxy proxy, String xForwardedProto) {
        if (!(proxy instanceof SSLableProxy)) {
            return false;
        }
        SSLableProxy sp = (SSLableProxy)proxy;
        return xForwardedProto != null ? "https".equals(xForwardedProto) : sp.isInboundSSL();
    }

    private static String getxForwardedProto(Exchange exc) {
        return exc.getRequest().getHeader().getFirstValue("X-Forwarded-Proto");
    }
}

