/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.oauth2.BufferedJsonGenerator;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.stream.Collectors;

public class WellknownFile {
    private static final String ISSUER = "issuer";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private static final String TOKEN_ENDPOINT = "token_endpoint";
    private static final String USERINFO_ENDPOINT = "userinfo_endpoint";
    private static final String REVOCATION_ENDPOINT = "revocation_endpoint";
    private static final String JWKS_URI = "jwks_uri";
    private static final String END_SESSION_ENDPOINT = "end_session_endpoint";
    private static final String RESPONSE_TYPES_SUPPORTED = "response_types_supported";
    private static final String RESPONSE_MODES_SUPPORTED = "response_modes_supported";
    private static final String SUBJECT_TYPES_SUPPORTED = "subject_types_supported";
    private static final String ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED = "id_token_signing_alg_values_supported";
    private static final String SCOPES_SUPPORTED = "scopes_supported";
    private static final String TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED = "token_endpoint_auth_methods_supported";
    private static final String CLAIMS_SUPPORTED = "claims_supported";
    private String wellknown;
    private OAuth2AuthorizationServerInterceptor oasi;
    private ResolverMap resolver;
    private String authorizationEndpoint;
    private String issuer;
    private String tokenEndpoint;
    private String userinfoEndpoint;
    private String revocationEndpoint;
    private String jwksUri;
    private String endSessionEndpoint;
    private String supportedResponseTypes;
    private String supportedResponseModes;
    private String supportedSubjectType;
    private String supportedIdTokenSigningAlgValues;
    private String supportedScopes;
    private String supportedTokenEndpointAuthMethods;
    private String supportedClaims;

    public void init(Router router, OAuth2AuthorizationServerInterceptor oasi) throws IOException {
        this.resolver = router.getResolverMap();
        this.oasi = oasi;
        this.getValuesFromOasi();
        this.writeWellknown();
    }

    public void init(Router router) throws IOException {
        this.init(router, null);
    }

    private String getOauth2Issuer() {
        return this.oasi.getIssuer();
    }

    private String baseOauth2Url() {
        return ResolverMap.combine(this.getOauth2Issuer() + "/", "oauth2/");
    }

    private void getValuesFromOasi() throws UnsupportedEncodingException {
        if (this.oasi == null) {
            return;
        }
        this.setIssuer(this.getOauth2Issuer());
        this.setAuthorizationEndpoint(this.baseOauth2Url() + "auth");
        this.setTokenEndpoint(this.baseOauth2Url() + "token");
        this.setUserinfoEndpoint(this.baseOauth2Url() + "userinfo");
        this.setRevocationEndpoint(this.oasi.getTokenGenerator().supportsRevocation() ? this.baseOauth2Url() + "revoke" : null);
        this.setJwksUri(this.baseOauth2Url() + "certs");
        this.setSupportedResponseTypes(this.oasi.getSupportedAuthorizationGrants());
        this.setSupportedResponseModes("query fragment");
        this.setSupportedSubjectType("public");
        this.setSupportedIdTokenSigningAlgValues("RS256");
        this.setSupportedScopes(this.getSupportedOasiScopes());
        this.setSupportedTokenEndpointAuthMethods("client_secret_post");
        this.setSupportedClaims(this.getSupportedOasiClaims());
    }

    private String getSupportedOasiClaims() {
        return this.oasi.getClaimList().getSupportedClaimsAsString();
    }

    private String getSupportedOasiScopes() {
        return this.oasi.getClaimList().getSupportedScopes();
    }

    private void writeWellknown() throws IOException {
        try (BufferedJsonGenerator bufferedJsonGenerator = new BufferedJsonGenerator();){
            JsonGenerator jg = bufferedJsonGenerator.getJsonGenerator();
            jg.writeStartObject();
            this.writeIssuer(jg);
            this.writeAuthorizationEndpoint(jg);
            this.writeTokenEndpoint(jg);
            this.writeUserinfoEndpoint(jg);
            this.writeRevocationEndpoint(jg);
            this.writeJwksUri(jg);
            this.writeEndSessionEndpoint(jg);
            this.writeSupportedResponseTypes(jg);
            this.writeSupportedResponseModes(jg);
            this.writeSupportedSubjectTypes(jg);
            this.writeSupportedIdTokenSigningAlgValues(jg);
            this.writeSupportedScopes(jg);
            this.writeSupportedTokenEndpointAuthMethods(jg);
            this.writeSupportedClaims(jg);
            jg.writeEndObject();
            this.setWellknown(bufferedJsonGenerator.getJson());
        }
    }

    private void writeSupportedClaims(JsonGenerator jg) throws IOException {
        this.stringEnumToJson(jg, CLAIMS_SUPPORTED, this.getSupportedClaims().split(" "));
    }

    private void writeSupportedTokenEndpointAuthMethods(JsonGenerator jg) throws IOException {
        this.stringEnumToJson(jg, TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED, this.getSupportedTokenEndpointAuthMethods().split(" "));
    }

    private void writeSupportedScopes(JsonGenerator jg) throws IOException {
        this.stringEnumToJson(jg, SCOPES_SUPPORTED, this.getSupportedScopes().split(" "));
    }

    private void writeSupportedIdTokenSigningAlgValues(JsonGenerator jg) throws IOException {
        this.stringEnumToJson(jg, ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED, this.getSupportedIdTokenSigningAlgValues().split(" "));
    }

    private void writeSupportedSubjectTypes(JsonGenerator jg) throws IOException {
        this.stringEnumToJson(jg, SUBJECT_TYPES_SUPPORTED, this.getSupportedSubjectType().split(" "));
    }

    private void stringEnumToJson(JsonGenerator jg, String name, String ... enumeration) throws IOException {
        jg.writeArrayFieldStart(name);
        for (String value : enumeration) {
            jg.writeString(OAuth2Util.urldecode(value));
        }
        jg.writeEndArray();
    }

    private void writeSupportedResponseTypes(JsonGenerator jg) throws IOException {
        this.stringEnumToJson(jg, RESPONSE_TYPES_SUPPORTED, this.getSupportedResponseTypes().split(" "));
    }

    private void writeSupportedResponseModes(JsonGenerator jg) throws IOException {
        if (this.supportedResponseModes != null) {
            this.stringEnumToJson(jg, RESPONSE_MODES_SUPPORTED, this.getSupportedResponseModes().split(" "));
        }
    }

    private void writeJwksUri(JsonGenerator jg) throws IOException {
        this.writeSingleJsonField(jg, JWKS_URI, this.getJwksUri());
    }

    private void writeEndSessionEndpoint(JsonGenerator jg) throws IOException {
        if (this.getEndSessionEndpoint() != null) {
            this.writeSingleJsonField(jg, END_SESSION_ENDPOINT, this.getEndSessionEndpoint());
        }
    }

    private void writeSingleJsonField(JsonGenerator jg, String name, String value) throws IOException {
        jg.writeObjectField(name, (Object)value);
    }

    private void writeRevocationEndpoint(JsonGenerator jg) throws IOException {
        String revocationEndpoint1 = this.getRevocationEndpoint();
        if (revocationEndpoint1 != null) {
            this.writeSingleJsonField(jg, REVOCATION_ENDPOINT, revocationEndpoint1);
        }
    }

    private void writeUserinfoEndpoint(JsonGenerator jg) throws IOException {
        this.writeSingleJsonField(jg, USERINFO_ENDPOINT, this.getUserinfoEndpoint());
    }

    private void writeTokenEndpoint(JsonGenerator jg) throws IOException {
        this.writeSingleJsonField(jg, TOKEN_ENDPOINT, this.getTokenEndpoint());
    }

    private void writeAuthorizationEndpoint(JsonGenerator jg) throws IOException {
        this.writeSingleJsonField(jg, AUTHORIZATION_ENDPOINT, this.getAuthorizationEndpoint());
    }

    private void writeIssuer(JsonGenerator jg) throws IOException {
        this.writeSingleJsonField(jg, ISSUER, this.getIssuer());
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpoint(String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public String getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    public void setSupportedResponseTypes(Set<String> supportedResponseTypes) {
        StringBuilder builder = new StringBuilder();
        for (String resp : supportedResponseTypes) {
            builder.append(" ").append(OAuth2Util.urlencode(resp));
        }
        this.setSupportedResponseTypes(builder.toString().trim());
    }

    public void setSupportedResponseTypes(String supportedResponseTypes) {
        this.supportedResponseTypes = supportedResponseTypes;
    }

    public String getSupportedResponseModes() {
        return this.supportedResponseModes;
    }

    public void setSupportedResponseModes(Set<String> supportedResponseModes) {
        StringBuilder builder = new StringBuilder();
        for (String resp : supportedResponseModes) {
            builder.append(" ").append(OAuth2Util.urlencode(resp));
        }
        this.setSupportedResponseModes(builder.toString().trim());
    }

    public void setSupportedResponseModes(String supportedResponseModes) {
        this.supportedResponseModes = supportedResponseModes;
    }

    public String getSupportedSubjectType() {
        return this.supportedSubjectType;
    }

    public void setSupportedSubjectType(String supportedSubjectType) {
        this.supportedSubjectType = supportedSubjectType;
    }

    public String getSupportedIdTokenSigningAlgValues() {
        return this.supportedIdTokenSigningAlgValues;
    }

    public void setSupportedIdTokenSigningAlgValues(String supportedIdTokenSigningAlgValues) {
        this.supportedIdTokenSigningAlgValues = supportedIdTokenSigningAlgValues;
    }

    public String getSupportedScopes() {
        return this.supportedScopes;
    }

    public void setSupportedScopes(String supportedScopes) {
        this.supportedScopes = supportedScopes;
    }

    public String getSupportedTokenEndpointAuthMethods() {
        return this.supportedTokenEndpointAuthMethods;
    }

    public void setSupportedTokenEndpointAuthMethods(String supportedTokenEndpointAuthMethods) {
        this.supportedTokenEndpointAuthMethods = supportedTokenEndpointAuthMethods;
    }

    public String getSupportedClaims() {
        return this.supportedClaims;
    }

    public void setSupportedClaims(String supportedClaims) {
        this.supportedClaims = supportedClaims;
    }

    public void setSupportedClaims(Set<String> supportedClaims) {
        this.setSupportedClaims(supportedClaims.stream().map(OAuth2Util::urlencode).collect(Collectors.joining(" ")));
    }

    public String getWellknown() {
        return this.wellknown;
    }

    public void setWellknown(String wellknown) {
        this.wellknown = wellknown;
    }
}

