/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.authorizationservice;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AnswerParameters;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.JwtGenerator;
import com.predic8.membrane.core.interceptor.oauth2client.rf.LogHelper;
import com.predic8.membrane.core.interceptor.oauth2client.rf.token.JWSSigner;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.transport.ssl.PEMSupport;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.codec.binary.Base64;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorizationService {
    protected Logger log;
    private HttpClient httpClient;
    protected Router router;
    protected HttpClientConfiguration httpClientConfiguration;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private String clientId;
    @GuardedBy(value="lock")
    private String clientSecret;
    private JWSSigner JWSSigner;
    protected String scope;
    private SSLParser sslParser;
    private SSLContext sslContext;
    private boolean useJWTForClientAuth;
    private final LogHelper logHelper = new LogHelper();
    protected boolean supportsDynamicRegistration = false;

    public boolean supportsDynamicRegistration() {
        return this.supportsDynamicRegistration;
    }

    public void init(Router router) throws Exception {
        this.log = LoggerFactory.getLogger((String)this.getClass().getName());
        if (this.isUseJWTForClientAuth()) {
            this.JWSSigner = new JWSSigner(PEMSupport.getInstance().parseKey(this.getSslParser().getKey().getPrivate().get(router.getResolverMap(), router.getBaseLocation())), this.getSslParser().getKey().getCertificates().getFirst().get(router.getResolverMap(), router.getBaseLocation()));
        }
        this.setHttpClient(router.getHttpClientFactory().createClient(this.getHttpClientConfiguration()));
        if (this.sslParser != null) {
            this.sslContext = new StaticSSLContext(this.sslParser, router.getResolverMap(), router.getBaseLocation());
        }
        this.router = router;
        this.init();
        if (!this.supportsDynamicRegistration()) {
            this.checkForClientIdAndSecret();
        }
    }

    public abstract void init() throws Exception;

    public abstract String getIssuer();

    public abstract String getJwksEndpoint() throws Exception;

    public abstract String getEndSessionEndpoint() throws Exception;

    public abstract String getLoginURL(String var1, String var2, String var3);

    public abstract String getUserInfoEndpoint();

    public abstract String getSubject();

    public abstract String getTokenEndpoint();

    public abstract String getRevocationEndpoint();

    protected void doDynamicRegistration(List<String> callbackURLs) throws Exception {
    }

    public void dynamicRegistration(List<String> callbackURLs) throws Exception {
        if (this.supportsDynamicRegistration()) {
            this.doDynamicRegistration(callbackURLs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForClientIdAndSecret() {
        Object object = this.lock;
        synchronized (object) {
            if (this.clientId == null) {
                throw new RuntimeException(this.getClass().getSimpleName() + " cannot work without specified clientId");
            }
            if (this.clientSecret == null && this.sslParser == null) {
                throw new RuntimeException(this.getClass().getSimpleName() + " cannot work without either clientSecret or a client key+certificate");
            }
        }
    }

    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpClientConfiguration;
    }

    @MCAttribute
    public void setHttpClientConfiguration(HttpClientConfiguration httpClientConfiguration) {
        this.httpClientConfiguration = httpClientConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientId() {
        Object object = this.lock;
        synchronized (object) {
            return this.clientId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MCAttribute
    public void setClientId(String clientId) {
        Object object = this.lock;
        synchronized (object) {
            this.clientId = clientId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientSecret() {
        Object object = this.lock;
        synchronized (object) {
            return this.clientSecret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MCAttribute
    public void setClientSecret(String clientSecret) {
        Object object = this.lock;
        synchronized (object) {
            this.clientSecret = clientSecret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClientIdAndSecret(String clientId, String clientSecret) {
        Object object = this.lock;
        synchronized (object) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }
    }

    public String getScope() {
        return this.scope;
    }

    @MCAttribute
    public void setScope(String scope) {
        this.scope = scope;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Response doRequest(Exchange e) throws Exception {
        if (this.sslContext != null) {
            e.setProperty("membrane.ssl.context", this.sslContext);
        }
        return this.getHttpClient().call(e).getResponse();
    }

    public SSLParser getSslParser() {
        return this.sslParser;
    }

    @MCChildElement(order=20, allowForeign=true)
    public void setSslParser(SSLParser sslParser) {
        this.sslParser = sslParser;
    }

    public boolean isUseJWTForClientAuth() {
        return this.useJWTForClientAuth;
    }

    @MCAttribute
    public void setUseJWTForClientAuth(boolean useJWTForClientAuth) {
        this.useJWTForClientAuth = useJWTForClientAuth;
    }

    public JWSSigner getJwtKeyCertHandler() {
        return this.JWSSigner;
    }

    public Request.Builder applyAuth(Request.Builder requestBuilder, String body) {
        String clientSecret;
        if (this.isUseJWTForClientAuth()) {
            body = (String)body + "&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer&client_assertion=" + this.createClientToken();
        }
        if ((clientSecret = this.getClientSecret()) != null) {
            requestBuilder.header("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(this.getClientId() + ":" + clientSecret).getBytes()))).body((String)body);
        } else {
            requestBuilder.body((String)body + "&client_id" + this.getClientId());
        }
        return requestBuilder;
    }

    public Response refreshTokenRequest(Session session, OAuth2AnswerParameters params, String wantedScope) throws Exception {
        String tokenEndpoint = this.getTokenEndpoint();
        if (session.get("defaultFlow") != null) {
            tokenEndpoint = tokenEndpoint.replaceAll((String)session.get("defaultFlow"), (String)session.get("triggerFlow"));
        }
        Exchange e = this.applyAuth(new Request.Builder().post(tokenEndpoint).contentType("application/x-www-form-urlencoded").header("Accept", "application/json").header("User-Agent", Constants.USERAGENT), "grant_type=refresh_token&refresh_token=" + params.getRefreshToken() + (String)(wantedScope != null ? "&scope=" + URLEncoder.encode(wantedScope, StandardCharsets.UTF_8) : "")).buildExchange();
        this.logHelper.handleRequest(e);
        Response response = this.doRequest(e);
        this.logHelper.handleResponse(e);
        return response;
    }

    public Response requestUserEndpoint(OAuth2AnswerParameters params) throws Exception {
        return this.doRequest(new Request.Builder().get(this.getUserInfoEndpoint()).header("Authorization", params.getTokenType() + " " + params.getAccessToken()).header("User-Agent", Constants.USERAGENT).header("Accept", "application/json").buildExchange());
    }

    public boolean idTokenIsValid(String idToken) {
        try {
            JwtGenerator.getClaimsFromSignedIdToken(idToken, this.getIssuer(), this.getClientId(), this.getJwksEndpoint(), this);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String createClientToken() {
        try {
            String jwtSub = this.getClientId();
            String jwtAud = this.getTokenEndpoint();
            JwtClaims jwtClaims = new JwtClaims();
            jwtClaims.setSubject(jwtSub);
            jwtClaims.setAudience(jwtAud);
            jwtClaims.setIssuer(jwtClaims.getSubject());
            jwtClaims.setJwtId(UUID.randomUUID().toString());
            jwtClaims.setIssuedAtToNow();
            NumericDate expiration = NumericDate.now();
            expiration.addSeconds(300L);
            jwtClaims.setExpirationTime(expiration);
            jwtClaims.setNotBeforeMinutesInThePast(2.0f);
            return this.JWSSigner.signToCompactSerialization(jwtClaims.toJson());
        }
        catch (MalformedClaimException | JoseException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream resolve(ResolverMap rm, String baseLocation, String url) throws Exception {
        if ((url = ResolverMap.combine(baseLocation, url)).startsWith("http")) {
            return this.httpClient.call(Request.get(url).buildExchange()).getResponse().getBodyAsStreamDecoded();
        }
        return rm.resolve(url);
    }
}

