/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.authorizationservice;

import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.BufferedJsonGenerator;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import com.predic8.membrane.core.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@MCElement(name="registration")
public class DynamicRegistration {
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private SSLParser sslParser;
    private SSLContext sslContext;
    private HttpClient client;
    private HttpClientConfiguration httpClientConfiguration;
    private Router router;

    public void init(Router router) {
        this.router = router;
        if (this.sslParser != null) {
            this.sslContext = new StaticSSLContext(this.sslParser, router.getResolverMap(), router.getBaseLocation());
        }
        for (Interceptor i : this.interceptors) {
            i.init(router);
        }
        this.client = router.getHttpClientFactory().createClient(this.httpClientConfiguration);
    }

    public InputStream retrieveOpenIDConfiguration(String uri) throws Exception {
        return this.doRequest(new Request.Builder().get(uri).buildExchange()).getBodyAsStream();
    }

    public Client registerWithCallbackAt(List<String> callbackUris, String registrationEndpoint) throws Exception {
        Exchange exc = new Request.Builder().post(registrationEndpoint).header("Content-Type", "application/json;charset=utf-8").body(this.getRegistrationBody(callbackUris)).buildExchange();
        HashMap<String, String> json = Util.parseSimpleJSONResponse(this.doRequest(exc));
        if (!json.containsKey("client_id") || !json.containsKey("client_secret")) {
            throw new RuntimeException("Registration endpoint didn't return clientId/clientSecret");
        }
        return new Client(json.get("client_id"), json.get("client_secret"), "", json.get("grant_types"));
    }

    private Response doRequest(Exchange exc) throws Exception {
        if (this.sslContext != null) {
            exc.setProperty("membrane.ssl.context", this.sslContext);
        }
        if (this.router.getFlowController().invokeRequestHandlers(exc, this.interceptors) != Outcome.CONTINUE) {
            throw new RuntimeException("Registration interceptorchain (request) had a problem");
        }
        Response response = this.client.call(exc).getResponse();
        this.router.getFlowController().invokeResponseHandlers(exc, this.interceptors);
        if (response.getStatusCode() < 200 || response.getStatusCode() > 201) {
            throw new RuntimeException("Registration endpoint didn't return successful: " + response.getStatusMessage());
        }
        return response;
    }

    private String getRegistrationBody(List<String> callbackUris) throws IOException {
        try (BufferedJsonGenerator bufferedJsonGenerator = new BufferedJsonGenerator();){
            JsonGenerator jg = bufferedJsonGenerator.getJsonGenerator();
            jg.writeStartObject();
            jg.writeArrayFieldStart("redirect_uris");
            for (String callbackUri : callbackUris) {
                jg.writeString(callbackUri);
            }
            jg.writeEndArray();
            jg.writeEndObject();
            String string = bufferedJsonGenerator.getJson();
            return string;
        }
    }

    public SSLParser getSslParser() {
        return this.sslParser;
    }

    @MCChildElement(order=10, allowForeign=true)
    public void setSslParser(SSLParser sslParser) {
        this.sslParser = sslParser;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @MCChildElement(order=20)
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpClientConfiguration;
    }

    @MCChildElement(order=30)
    public void setHttpClientConfiguration(HttpClientConfiguration httpClientConfiguration) {
        this.httpClientConfiguration = httpClientConfiguration;
    }
}

