/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.authorizationservice;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.interceptor.oauth2.ClaimRenamer;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.DynamicRegistration;
import com.predic8.membrane.core.interceptor.oauth2.parameter.ClaimsParameter;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@MCElement(name="membrane")
public class MembraneAuthorizationService
extends AuthorizationService {
    private String src;
    private String internalSrc;
    private String issuer;
    private String tokenEndpoint;
    private String userInfoEndpoint;
    private String subject = ClaimRenamer.convert("sub");
    private String authorizationEndpoint;
    private String publicAuthorizationEndpoint;
    private String revocationEndpoint;
    private String registrationEndpoint;
    private String jwksEndpoint;
    private String endSessionEndpoint;
    private String claims;
    private String claimsIdt;
    private String claimsParameter;
    private List<String> responseModesSupported = List.of("query", "fragment");
    private DynamicRegistration dynamicRegistration;
    protected boolean encodedScope;

    public static boolean isValidURI(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void init() throws Exception {
        if (this.src == null) {
            throw new Exception("No wellknown file source configured. - Cannot work without one");
        }
        if (this.dynamicRegistration != null) {
            this.dynamicRegistration.init(this.router);
            this.supportsDynamicRegistration = true;
        }
        this.parseSrc(this.resolve(this.router.getResolverMap(), this.router.getBaseLocation(), this.getWellKnownUrl(this.internalSrc == null ? this.src : this.internalSrc)));
        if (this.internalSrc != null) {
            this.publicAuthorizationEndpoint = this.src + new URI(this.authorizationEndpoint).getPath();
        }
        this.adjustScope();
        this.prepareClaimsForLoginUrl();
    }

    @NotNull
    private String getWellKnownUrl(String baseUrl) {
        return baseUrl + (baseUrl.endsWith("/") ? "" : "/") + ".well-known/openid-configuration";
    }

    @Override
    public InputStream resolve(ResolverMap rm, String baseLocation, String url) throws Exception {
        return this.dynamicRegistration != null ? this.dynamicRegistration.retrieveOpenIDConfiguration(url) : super.resolve(rm, baseLocation, url);
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getJwksEndpoint() throws Exception {
        return this.jwksEndpoint;
    }

    @Override
    public String getEndSessionEndpoint() throws Exception {
        return this.endSessionEndpoint;
    }

    @Override
    protected void doDynamicRegistration(List<String> callbackURLs) throws Exception {
        if (this.dynamicRegistration == null || this.registrationEndpoint == null || this.registrationEndpoint.isEmpty()) {
            throw new RuntimeException("A registration bean is required and src needs to specify a registration endpoint");
        }
        this.dynamicRegistrationIfNeeded(callbackURLs);
    }

    private void dynamicRegistrationIfNeeded(List<String> callbackUris) throws Exception {
        Client client = this.dynamicRegistration.registerWithCallbackAt(callbackUris, this.registrationEndpoint);
        this.setClientIdAndSecret(client.getClientId(), client.getClientSecret());
    }

    private void prepareClaimsForLoginUrl() throws IOException {
        this.claimsParameter = ClaimsParameter.writeCompleteJson(this.claims, this.claimsIdt);
        if (this.claimsParameter.isEmpty()) {
            this.claimsParameter = null;
        }
    }

    @Override
    public void setScope(String scope) {
        super.setScope(scope);
        this.encodedScope = false;
    }

    private void adjustScope() throws UnsupportedEncodingException {
        if (this.scope == null) {
            this.scope = "profile";
        }
        if (!this.encodedScope) {
            this.scope = OAuth2Util.urlencode(this.scope);
            this.encodedScope = true;
        }
    }

    private void parseSrc(InputStream resolve) throws IOException {
        String file = IOUtils.toString((InputStream)resolve);
        ObjectMapper mapper = new ObjectMapper();
        Map json = (Map)mapper.readValue(file, (TypeReference)new TypeReference<Map<String, Object>>(this){});
        this.tokenEndpoint = (String)json.get("token_endpoint");
        if (this.tokenEndpoint == null) {
            throw new RuntimeException("No token_endpoint could be detected.");
        }
        this.userInfoEndpoint = (String)json.get("userinfo_endpoint");
        this.authorizationEndpoint = (String)json.get("authorization_endpoint");
        this.revocationEndpoint = (String)json.get("revocation_endpoint");
        this.registrationEndpoint = (String)json.get("registration_endpoint");
        this.jwksEndpoint = (String)json.get("jwks_uri");
        this.endSessionEndpoint = (String)json.get("end_session_endpoint");
        this.issuer = (String)json.get("issuer");
        if (json.containsKey("response_modes_supported")) {
            List v = (List)json.get("response_modes_supported");
            this.responseModesSupported = v.stream().filter(i -> i instanceof String).map(i -> (String)i).collect(Collectors.toList());
        }
    }

    @Override
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Override
    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    @Override
    public String getLoginURL(String securityToken, String callbackURL, String pathQuery) {
        String endpoint = this.publicAuthorizationEndpoint;
        if (endpoint == null) {
            endpoint = this.authorizationEndpoint;
        }
        boolean formPostSupported = this.responseModesSupported.contains("form_post");
        return endpoint + "?client_id=" + this.getClientId() + "&response_type=code&scope=" + this.scope + "&redirect_uri=" + callbackURL + "&" + (formPostSupported ? "response_mode=form_post&" : "") + "state=security_token%3D" + securityToken + "%26url%3D" + OAuth2Util.urlencode(pathQuery) + this.getClaimsParameter();
    }

    private String getClaimsParameter() {
        if (this.claimsParameter == null) {
            return "";
        }
        return "&claims=" + OAuth2Util.urlencode(this.claimsParameter);
    }

    @Override
    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @MCAttribute
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSrc() {
        return this.src;
    }

    @MCAttribute
    @Required
    public void setSrc(String src) {
        this.src = src;
    }

    public String getInternalSrc() {
        return this.internalSrc;
    }

    @MCAttribute
    public void setInternalSrc(String internalSrc) {
        this.internalSrc = internalSrc;
    }

    public String getClaims() {
        return this.claims;
    }

    @MCAttribute
    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getClaimsIdt() {
        return this.claimsIdt;
    }

    @MCAttribute
    public void setClaimsIdt(String claimsIdt) {
        this.claimsIdt = claimsIdt;
    }

    public DynamicRegistration getDynamicRegistration() {
        return this.dynamicRegistration;
    }

    @MCChildElement(order=10)
    public void setDynamicRegistration(DynamicRegistration dynamicRegistration) {
        this.dynamicRegistration = dynamicRegistration;
    }

    public List<String> getResponseModesSupported() {
        return this.responseModesSupported;
    }
}

