/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.parameter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.interceptor.oauth2.BufferedJsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClaimsParameter {
    public static final String USERINFO = "userinfo";
    public static final String ID_TOKEN = "id_token";
    private final Set<String> supportedClaims;
    private Map<String, Object> cleanedJson;

    public ClaimsParameter(Set<String> supportedClaims, String claimsParameter) {
        this.supportedClaims = supportedClaims;
        if (claimsParameter != null && !claimsParameter.isEmpty()) {
            this.parseClaimsParameter(claimsParameter);
        }
    }

    public static String writeCompleteJson(String userinfoClaims, String idTokenClaims) throws IOException {
        String[] userinfo = null;
        if (userinfoClaims != null && !userinfoClaims.isEmpty()) {
            userinfo = userinfoClaims.split(" ");
        }
        String[] idToken = null;
        if (idTokenClaims != null && !idTokenClaims.isEmpty()) {
            idToken = idTokenClaims.split(" ");
        }
        return ClaimsParameter.writeCompleteJson(userinfo, idToken);
    }

    public static String writeCompleteJson(String[] userinfoClaims, String[] idTokenClaims) throws IOException {
        if (userinfoClaims == null && idTokenClaims == null) {
            return "";
        }
        try (BufferedJsonGenerator bufferedJsonGenerator = new BufferedJsonGenerator();){
            JsonGenerator gen = bufferedJsonGenerator.getJsonGenerator();
            gen.writeStartObject();
            if (userinfoClaims != null) {
                ClaimsParameter.writeSingleClaimsObject(gen, USERINFO, userinfoClaims);
            }
            if (idTokenClaims != null) {
                ClaimsParameter.writeSingleClaimsObject(gen, ID_TOKEN, idTokenClaims);
            }
            gen.writeEndObject();
            String string = bufferedJsonGenerator.getJson();
            return string;
        }
    }

    static void writeSingleClaimsObject(JsonGenerator gen, String objectName, String ... claims) throws IOException {
        gen.writeObjectFieldStart(objectName);
        for (String claim : claims) {
            gen.writeObjectField(claim, null);
        }
        gen.writeEndObject();
    }

    private void parseClaimsParameter(String claimsParameter) {
        try {
            this.cleanedJson = this.getCleanedJson((Map)new ObjectMapper().readValue(claimsParameter, (TypeReference)new TypeReference<Map<String, Object>>(this){}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Map<String, Object> getCleanedJson(Map<String, Object> json) {
        this.cleanJsonObjectFromInvalidClaims(json, USERINFO);
        this.cleanJsonObjectFromInvalidClaims(json, ID_TOKEN);
        if (json.isEmpty()) {
            json = null;
        }
        return json;
    }

    private void cleanJsonObjectFromInvalidClaims(Map<String, Object> json, String name) {
        if (json.containsKey(name)) {
            this.cleanFromInvalidClaims((Map)json.get(name));
            if (((Map)json.get(name)).isEmpty()) {
                json.remove(name);
            }
        }
    }

    private void cleanFromInvalidClaims(Map<String, Object> json) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String claim : json.keySet()) {
            if (this.supportedClaims.contains(claim)) continue;
            toRemove.add(claim);
        }
        for (String claim : toRemove) {
            json.remove(claim);
        }
    }

    public boolean hasClaims() {
        return this.cleanedJson != null;
    }

    public String toJson() throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString(this.cleanedJson);
    }

    private Map<String, Object> getObject(String objectName) {
        if (this.cleanedJson == null || this.cleanedJson.get(objectName) == null) {
            return new HashMap<String, Object>();
        }
        return (Map)this.cleanedJson.get(objectName);
    }

    private HashSet<String> getClaimsFromJsonObject(String objectName) {
        return new HashSet<String>(this.getObject(objectName).keySet());
    }

    public HashSet<String> getUserinfoClaims() {
        return this.getClaimsFromJsonObject(USERINFO);
    }

    public HashSet<String> getIdTokenClaims() {
        return this.getClaimsFromJsonObject(ID_TOKEN);
    }
}

