/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.request.AuthWithSessionRequest;
import com.predic8.membrane.core.interceptor.oauth2.request.AuthWithoutSessionRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthEndpointProcessor
extends EndpointProcessor {
    private static final Logger log = LoggerFactory.getLogger(AuthEndpointProcessor.class);

    public AuthEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith(this.authServer.getBasePath() + "/oauth2/auth") && !this.authServer.isLoginViewDisabled();
    }

    @Override
    public Outcome process(Exchange exc) {
        try {
            return this.processInternal(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(true, "auth-endpoint-processor").exception(e).stacktrace(true).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    private Outcome processInternal(Exchange exc) throws Exception {
        SessionManager.Session s = this.authServer.getSessionManager().getSession(exc);
        if (s != null) {
            exc.setResponse(new AuthWithSessionRequest(this.authServer, exc).validateRequest());
            return Outcome.RETURN;
        }
        exc.setResponse(new AuthWithoutSessionRequest(this.authServer, exc).validateRequest());
        return Outcome.RETURN;
    }
}

