/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.beautifier.JSONBeautifier;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertsEndpointProcessor
extends EndpointProcessor {
    private static final Logger log = LoggerFactory.getLogger(CertsEndpointProcessor.class);
    private final JSONBeautifier jsonBeautifier = new JSONBeautifier();

    public CertsEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith(this.authServer.getBasePath() + "/oauth2/certs");
    }

    @Override
    public Outcome process(Exchange exc) {
        String accessTokenJWKIfAvailable = this.authServer.getTokenGenerator().getJwkIfAvailable();
        String idTokenJWK = this.authServer.getJwtGenerator().getJwk();
        String jwks = "{\"keys\": [ " + idTokenJWK + (String)(accessTokenJWKIfAvailable != null ? "," + accessTokenJWKIfAvailable : "") + "]}";
        try {
            exc.setResponse(Response.ok().contentType("application/json;charset=utf-8").body(this.jsonBeautifier.beautify(jwks)).build());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(true, "certs-endpoint-processor").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        return Outcome.RETURN;
    }
}

