/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointProcessor
extends EndpointProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultEndpointProcessor.class);

    public DefaultEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return true;
    }

    @Override
    public Outcome process(Exchange exc) {
        if (exc.getResponse() == null) {
            try {
                exc.setResponse(OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_request"));
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                ProblemDetails.internal(true, "endpoint-processor").component(this.getClass().getSimpleName()).exception(e).buildAndSetResponse(exc);
                return Outcome.ABORT;
            }
        }
        return Outcome.RETURN;
    }
}

