/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.LoginDialog;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginDialogEndpointProcessor
extends EndpointProcessor {
    private static final Logger log = LoggerFactory.getLogger(LoginDialogEndpointProcessor.class);
    private final LoginDialog loginDialog;

    public LoginDialogEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
        if (authServer.isLoginViewDisabled()) {
            this.loginDialog = null;
            return;
        }
        this.loginDialog = new LoginDialog(authServer.getUserDataProvider(), null, authServer.getSessionManager(), authServer.getAccountBlocker(), authServer.getLocation(), authServer.getBasePath(), authServer.getPath(), authServer.isExposeUserCredentialsToSession(), authServer.getMessage());
        try {
            this.loginDialog.init(authServer.getRouter());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        URI uri = this.uriFactory.createWithoutException(exc.getRequest().getUri());
        return uri.getPath().startsWith(this.authServer.getBasePath() + this.authServer.getPath()) && this.authServer.getSessionManager().getSession(exc) != null;
    }

    @Override
    public Outcome process(Exchange exc) {
        try {
            this.loginDialog.handleLoginRequest(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(true, "login-dialog-endpoint-processor").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        return Outcome.RETURN;
    }
}

