/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import java.util.ArrayList;

public class OAuth2Processors {
    ArrayList<EndpointProcessor> processors = new ArrayList();

    public OAuth2Processors add(EndpointProcessor excProc) {
        this.processors.add(excProc);
        return this;
    }

    public Outcome runProcessors(Exchange exc) {
        for (EndpointProcessor excProc : this.processors) {
            if (!excProc.isResponsible(exc)) continue;
            Outcome result = excProc.process(exc);
            this.postProcessing(exc);
            return result;
        }
        throw new RuntimeException("No OAuthEndpointProcessor found. This should never happen!");
    }

    private void postProcessing(Exchange exc) {
        this.addAccessControlAllowOriginHeader(exc);
    }

    private void addAccessControlAllowOriginHeader(Exchange exc) {
        String origin = exc.getRequest().getHeader().getFirstValue("Origin");
        if (origin == null || origin.isEmpty()) {
            return;
        }
        exc.getResponse().getHeader().add("Access-Control-Allow-Origin", origin);
        exc.getResponse().getHeader().add("Access-Control-Allow-Credentials", "true");
    }
}

