/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.util.URLParamUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationEndpointProcessor
extends EndpointProcessor {
    private static final Logger log = LoggerFactory.getLogger(RevocationEndpointProcessor.class);

    public RevocationEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith(this.authServer.getBasePath() + "/oauth2/revoke");
    }

    @Override
    public Outcome process(Exchange exc) {
        try {
            return this.processInternal(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(true, "revocation-endpoint-processor").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Outcome processInternal(Exchange exc) throws Exception {
        Client client;
        Map<String, String> userAttributes;
        Map<String, String> params = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        if (!params.containsKey("token")) {
            exc.setResponse(OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_request"));
            return Outcome.RETURN;
        }
        SessionManager.Session session = this.authServer.getSessionFinder().getSessionForToken(params.get("token"));
        if (session == null) {
            exc.setResponse(Response.ok().bodyEmpty().build());
            return Outcome.RETURN;
        }
        Map<String, String> map = userAttributes = session.getUserAttributes();
        synchronized (map) {
            try {
                client = this.authServer.getClientList().getClient(userAttributes.get("client_id"));
            }
            catch (Exception e) {
                exc.setResponse(Response.ok().bodyEmpty().build());
                return Outcome.RETURN;
            }
        }
        String paramClientId = params.get("client_id");
        String paramClientSecret = params.get("client_secret");
        if (paramClientId != null && !client.getClientId().equals(paramClientId) || paramClientSecret != null && !client.getClientSecret().equals(paramClientSecret)) {
            exc.setResponse(OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_grant"));
            return Outcome.RETURN;
        }
        try {
            this.authServer.getTokenGenerator().invalidateToken(params.get("token"), client.getClientId(), client.getClientSecret());
        }
        catch (Exception e) {
            exc.setResponse(OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_grant"));
            return Outcome.RETURN;
        }
        Object object = session;
        synchronized (object) {
            session.clear();
        }
        object = this.authServer.getSessionManager();
        synchronized (object) {
            this.authServer.getSessionManager().removeSession(session);
        }
        object = this.authServer.getSessionFinder();
        synchronized (object) {
            this.authServer.getSessionFinder().removeSessionForToken(params.get("token"));
        }
        exc.setResponse(Response.ok().bodyEmpty().build());
        return Outcome.RETURN;
    }
}

