/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.TokenFlowDecider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenEndpointProcessor
extends EndpointProcessor {
    private static final Logger log = LoggerFactory.getLogger(TokenEndpointProcessor.class);

    public TokenEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith(this.authServer.getBasePath() + "/oauth2/token");
    }

    @Override
    public Outcome process(Exchange exc) {
        try {
            exc.setResponse(new TokenFlowDecider(this.authServer, exc).getFlow().validateRequest());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(true, "token-endpoint-processor").component(this.getClass().getSimpleName()).exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        if (exc.getResponse().getStatusCode() == 200) {
            this.authServer.getStatistics().accessTokenCreated();
        }
        return Outcome.RETURN;
    }
}

