/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.request.UserinfoRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserinfoEndpointProcessor
extends EndpointProcessor {
    private static final Logger log = LoggerFactory.getLogger(UserinfoEndpointProcessor.class);

    public UserinfoEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith(this.authServer.getBasePath() + "/oauth2/userinfo");
    }

    @Override
    public Outcome process(Exchange exc) {
        try {
            exc.setResponse(new UserinfoRequest(this.authServer, exc).validateRequest());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(true, "user-info-endpoint-processor").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        if (exc.getResponse().getStatusCode() == 200) {
            this.authServer.getStatistics().accessTokenValid();
        } else {
            this.authServer.getStatistics().accessTokenInvalid();
        }
        return Outcome.RETURN;
    }
}

