/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.beautifier.JSONBeautifier;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WellknownEndpointProcessor
extends EndpointProcessor {
    private static final Logger log = LoggerFactory.getLogger(WellknownEndpointProcessor.class);
    private JSONBeautifier jsonBeautifier = new JSONBeautifier();

    public WellknownEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith(this.authServer.getBasePath() + "/.well-known/openid-configuration");
    }

    @Override
    public Outcome process(Exchange exc) {
        try {
            exc.setResponse(Response.ok().contentType("application/json;charset=utf-8").body(this.jsonBeautifier.beautify(this.authServer.getWellknownFile().getWellknown())).build());
        }
        catch (IOException e) {
            log.error("While constructing the wellknown response.", (Throwable)e);
            ProblemDetails.internal(true, "wellknown-endpoint-processor").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        return Outcome.RETURN;
    }
}

