/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.ClaimRenamer;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.ClientList;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.parameter.ClaimsParameter;
import com.predic8.membrane.core.interceptor.oauth2.request.NoResponse;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.TokenRequest;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.JwtGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jose4j.lang.JoseException;

public class PasswordFlow
extends TokenRequest {
    public PasswordFlow(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        super(authServer, exc);
    }

    @Override
    protected Response checkForMissingParameters() throws Exception {
        if (this.getGrantType() == null || this.getUsername() == null || this.getPassword() == null || this.getClientId() == null || this.getClientSecret() == null) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_request");
        }
        return new NoResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response processWithParameters() throws Exception {
        Client client;
        SessionManager.Session session;
        if (!this.verifyClientThroughParams()) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "unauthorized_client");
        }
        Map<String, String> userParams = this.verifyUserThroughParams();
        if (userParams == null) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "access_denied");
        }
        this.scope = this.getScope();
        this.token = this.createTokenForVerifiedUserAndClient(userParams);
        this.expiration = this.authServer.getTokenGenerator().getExpiration();
        this.refreshToken = this.authServer.getRefreshTokenGenerator().getToken(this.getUsername(), this.getClientId(), this.getClientSecret(), this.claimsMapForRefresh(userParams));
        SessionManager.Session session2 = session = this.createSessionForAuthorizedUserWithParams();
        synchronized (session2) {
            session.getUserAttributes().put("access_token", this.token);
            session.getUserAttributes().putAll(userParams);
        }
        this.authServer.getSessionFinder().addSessionForToken(this.token, session);
        try {
            ClientList clientList = this.authServer.getClientList();
            synchronized (clientList) {
                client = this.authServer.getClientList().getClient(this.getClientId());
            }
        }
        catch (Exception e) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_client");
        }
        String grantTypes = client.getGrantTypes();
        if (!grantTypes.contains(this.getGrantType())) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_grant_type");
        }
        this.refreshToken = this.authServer.getRefreshTokenGenerator().getToken(client.getClientId(), client.getClientId(), client.getClientSecret(), this.claimsMapForRefresh(userParams));
        this.authServer.getSessionFinder().addSessionForRefreshToken(this.refreshToken, session);
        if (this.authServer.isIssueNonSpecIdTokens() && OAuth2Util.isOpenIdScope(this.scope)) {
            this.idToken = this.createSignedIdToken(session, client.getClientId(), client);
        }
        this.exc.setResponse(this.getEarlyResponse());
        return new NoResponse();
    }

    private JwtGenerator.Claim[] getValidIdTokenClaims(SessionManager.Session session) {
        ClaimsParameter cp = new ClaimsParameter(this.authServer.getClaimList().getSupportedClaims(), session.getUserAttributes().get("claims"));
        ArrayList<JwtGenerator.Claim> claims = new ArrayList<JwtGenerator.Claim>();
        if (cp.hasClaims()) {
            for (String claim : cp.getIdTokenClaims()) {
                claims.add(new JwtGenerator.Claim(claim, session.getUserAttributes().get(ClaimRenamer.convert(claim))));
            }
        }
        return claims.toArray(new JwtGenerator.Claim[0]);
    }

    private String createSignedIdToken(SessionManager.Session session, String username, Client client) throws JoseException {
        return this.getSignedIdToken(username, client, this.getValidIdTokenClaims(session));
    }

    private String getSignedIdToken(String username, Client client, JwtGenerator.Claim ... claims) throws JoseException {
        return this.authServer.getJwtGenerator().getSignedIdToken(this.authServer.getIssuer(), username, client.getClientId(), 600, claims);
    }

    @Override
    protected Response getResponse() throws Exception {
        return this.exc.getResponse();
    }

    private Response getEarlyResponse() throws IOException {
        return Response.ok().body(this.getTokenJSONResponse()).contentType("application/json;charset=utf-8").dontCache().build();
    }
}

