/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.ClaimRenamer;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.ClientList;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.parameter.ClaimsParameter;
import com.predic8.membrane.core.interceptor.oauth2.request.NoResponse;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.TokenRequest;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.JwtGenerator;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jose4j.lang.JoseException;

public class RefreshTokenFlow
extends TokenRequest {
    public RefreshTokenFlow(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        super(authServer, exc);
    }

    @Override
    protected Response checkForMissingParameters() throws Exception {
        if (this.getRefreshToken() == null || this.getClientId() == null || this.getClientSecret() == null) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_request");
        }
        return new NoResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response processWithParameters() throws Exception {
        SessionManager.Session session;
        Client client;
        Map<String, Object> additionalClaims;
        String username;
        if (!this.verifyClientThroughParams()) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "unauthorized_client");
        }
        try {
            username = this.authServer.getRefreshTokenGenerator().getUsername(this.getRefreshToken());
            additionalClaims = this.authServer.getRefreshTokenGenerator().getAdditionalClaims(this.getRefreshToken());
        }
        catch (NoSuchElementException ex) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_request");
        }
        this.params.put("username", username);
        try {
            if (this.authServer.getRefreshTokenGenerator().supportsRevocation()) {
                this.authServer.getRefreshTokenGenerator().invalidateToken(this.getRefreshToken(), this.getClientId(), this.getClientSecret());
            }
        }
        catch (NoSuchElementException ex) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_grant");
        }
        try {
            ClientList clientList = this.authServer.getClientList();
            synchronized (clientList) {
                client = this.authServer.getClientList().getClient(this.getClientId());
            }
        }
        catch (Exception e) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_client");
        }
        String grantTypes = client.getGrantTypes();
        if (!grantTypes.contains(this.getGrantType())) {
            return OAuth2Util.createParameterizedJsonErrorResponse("error", "invalid_grant_type");
        }
        this.scope = this.getScope();
        this.token = this.authServer.getTokenGenerator().getToken(this.getUsername(), this.getClientId(), this.getClientSecret(), this.claimsMapFromRefresh(additionalClaims));
        this.expiration = this.authServer.getTokenGenerator().getExpiration();
        this.refreshToken = this.authServer.getRefreshTokenGenerator().getToken(this.getUsername(), this.getClientId(), this.getClientSecret(), additionalClaims);
        SessionManager.Session session2 = session = this.authServer.getSessionFinder().getSessionForRefreshToken(this.getRefreshToken());
        synchronized (session2) {
            session.getUserAttributes().put("access_token", this.token);
        }
        this.authServer.getSessionFinder().addSessionForToken(this.token, session);
        this.authServer.getSessionFinder().addSessionForRefreshToken(this.refreshToken, session);
        if (OAuth2Util.isOpenIdScope(this.scope)) {
            this.idToken = this.createSignedIdToken(session, username, client);
        }
        return new NoResponse();
    }

    private String createSignedIdToken(SessionManager.Session session, String username, Client client) throws JoseException {
        return this.getSignedIdToken(username, client, this.getValidIdTokenClaims(session));
    }

    private String getSignedIdToken(String username, Client client, JwtGenerator.Claim ... claims) throws JoseException {
        return this.authServer.getJwtGenerator().getSignedIdToken(this.authServer.getIssuer(), username, client.getClientId(), 600, claims);
    }

    private JwtGenerator.Claim[] getValidIdTokenClaims(SessionManager.Session session) {
        ClaimsParameter cp = new ClaimsParameter(this.authServer.getClaimList().getSupportedClaims(), session.getUserAttributes().get("claims"));
        ArrayList<JwtGenerator.Claim> claims = new ArrayList<JwtGenerator.Claim>();
        if (cp.hasClaims()) {
            for (String claim : cp.getIdTokenClaims()) {
                claims.add(new JwtGenerator.Claim(claim, session.getUserAttributes().get(ClaimRenamer.convert(claim))));
            }
        }
        return claims.toArray(new JwtGenerator.Claim[0]);
    }

    @Override
    protected Response getResponse() throws Exception {
        return Response.ok().body(this.getTokenJSONResponse()).contentType("application/json;charset=utf-8").dontCache().build();
    }
}

