/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.oauth2.BufferedJsonGenerator;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.request.ParameterizedRequest;
import java.io.IOException;

public abstract class TokenRequest
extends ParameterizedRequest {
    public static final String ACCESS_TOKEN = "access_token";
    protected String scope;
    protected String token;
    protected String idToken;
    protected String refreshToken;
    protected long expiration;

    public TokenRequest(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        super(authServer, exc);
    }

    protected String getTokenJSONResponse() throws IOException {
        try (BufferedJsonGenerator bufferedJsonGenerator = new BufferedJsonGenerator();){
            JsonGenerator gen = bufferedJsonGenerator.getJsonGenerator();
            gen.writeStartObject();
            gen.writeObjectField(ACCESS_TOKEN, (Object)this.token);
            gen.writeObjectField("token_type", (Object)this.authServer.getTokenGenerator().getTokenType());
            if (this.expiration != 0L) {
                gen.writeObjectField("expires_in", (Object)this.expiration);
            }
            if (this.scope != null && !this.scope.isEmpty()) {
                gen.writeObjectField("scope", (Object)this.scope);
            }
            if (this.idToken != null && !this.idToken.isEmpty()) {
                gen.writeObjectField("id_token", (Object)this.idToken);
            }
            if (this.refreshToken != null && !this.refreshToken.isEmpty()) {
                gen.writeObjectField("refresh_token", (Object)this.refreshToken);
            }
            gen.writeEndObject();
            String string = bufferedJsonGenerator.getJson();
            return string;
        }
    }
}

