/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.tokengenerators;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.Blob;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.TokenGenerator;
import com.predic8.membrane.core.interceptor.session.JwtSessionManager;
import java.math.BigInteger;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="bearerJwtToken")
public class BearerJwtTokenGenerator
implements TokenGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(BearerJwtTokenGenerator.class);
    private final SecureRandom random = new SecureRandom();
    private RsaJsonWebKey rsaJsonWebKey;
    private JwtSessionManager.Jwk jwk;
    private long expiration;
    private boolean warningGeneratedKey = true;

    @Override
    public void init(Router router) throws Exception {
        if (this.jwk == null) {
            this.rsaJsonWebKey = this.generateKey();
            if (this.warningGeneratedKey) {
                LOG.warn("bearerJwtToken uses a generated key ('{}'). Sessions of this instance will not be compatible with sessions of other (e.g. restarted) instances. To solve this, write the JWK into a file and reference it using <bearerJwtToken><jwk location=\"...\">.", (Object)this.rsaJsonWebKey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
            }
        } else {
            this.rsaJsonWebKey = new RsaJsonWebKey(JsonUtil.parseJson((String)this.jwk.get(router.getResolverMap(), router.getBaseLocation())));
        }
    }

    private RsaJsonWebKey generateKey() throws JoseException {
        RsaJsonWebKey rsaJsonWebKey = RsaJwkGenerator.generateJwk((int)2048);
        rsaJsonWebKey.setKeyId(new BigInteger(130, this.random).toString(32));
        rsaJsonWebKey.setUse("sig");
        rsaJsonWebKey.setAlgorithm("RS256");
        return rsaJsonWebKey;
    }

    @Override
    public String getTokenType() {
        return "Bearer";
    }

    @Override
    public String getToken(String username, String clientId, String clientSecret, Map<String, Object> additionalClaims) {
        JwtClaims claims = new JwtClaims();
        claims.setSubject(username);
        claims.setClaim("clientId", (Object)clientId);
        if (this.expiration != 0L) {
            claims.setExpirationTimeMinutesInTheFuture((float)this.expiration / 60.0f);
        }
        if (additionalClaims != null) {
            additionalClaims.forEach((arg_0, arg_1) -> ((JwtClaims)claims).setClaim(arg_0, arg_1));
        }
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)this.rsaJsonWebKey.getRsaPrivateKey());
        jws.setAlgorithmHeaderValue("RS256");
        jws.setKeyIdHeaderValue(this.rsaJsonWebKey.getKeyId());
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new RuntimeException(e);
        }
    }

    public JwtClaims verify(String token) throws InvalidJwtException {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipDefaultAudienceValidation().setVerificationKey((Key)this.rsaJsonWebKey.getPublicKey()).build();
        return jwtConsumer.processToClaims(token);
    }

    @Override
    public String getUsername(String token) throws NoSuchElementException {
        try {
            return this.verify(token).getSubject();
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new NoSuchElementException(e);
        }
    }

    @Override
    public Map<String, Object> getAdditionalClaims(String token) throws NoSuchElementException {
        try {
            return this.verify(token).getClaimsMap().entrySet().stream().filter(e -> !this.isNormalClaim((String)e.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (InvalidJwtException e2) {
            throw new NoSuchElementException(e2);
        }
    }

    private boolean isNormalClaim(String key) {
        return "sub".equals(key) || "clientId".equals(key) || "exp".equals(key);
    }

    @Override
    public String getClientId(String token) throws NoSuchElementException {
        try {
            return (String)this.verify(token).getClaimValue("clientId", String.class);
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new NoSuchElementException(e);
        }
    }

    @Override
    public void invalidateToken(String token, String clientId, String clientSecret) throws NoSuchElementException {
        throw new IllegalStateException();
    }

    @Override
    public boolean supportsRevocation() {
        return false;
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @MCAttribute
    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public JwtSessionManager.Jwk getJwk() {
        return this.jwk;
    }

    @MCChildElement
    public void setJwk(JwtSessionManager.Jwk jwk) {
        this.jwk = jwk;
    }

    public boolean isWarningGeneratedKey() {
        return this.warningGeneratedKey;
    }

    public void setWarningGeneratedKey(boolean warningGeneratedKey) {
        this.warningGeneratedKey = warningGeneratedKey;
    }

    @Override
    public String getJwkIfAvailable() {
        return this.rsaJsonWebKey.toJson();
    }

    @MCElement(name="jwk", mixed=true, topLevel=false, id="bearerJwtToken-jwk")
    public static class Jwk
    extends Blob {
    }
}

