/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.exchange.snapshots.FakeProxy;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.interceptor.oauth2client.OriginalExchangeStore;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SSLableProxy;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="cookieOriginalExchangeStore")
public class CookieOriginialExchangeStore
extends OriginalExchangeStore {
    public static final String ORIGINAL_REQUEST_PREFIX = "_original_request_for_state_";
    private static final Logger log = LoggerFactory.getLogger(CookieOriginialExchangeStore.class);
    long expiresAfterSeconds = 900L;
    String domain;
    boolean httpOnly = true;
    String sameSite = null;

    private String originalRequestKeyNameInSession(String state) {
        return ORIGINAL_REQUEST_PREFIX + state;
    }

    public List<String> createCookieAttributes(Exchange exc) {
        return Stream.of("Max-Age=" + this.expiresAfterSeconds, "Expires=" + DateTimeFormatter.RFC_1123_DATE_TIME.format(OffsetDateTime.now(ZoneOffset.UTC).plus(Duration.ofSeconds(this.expiresAfterSeconds))), "Path=/", CookieOriginialExchangeStore.getSecureAttribute(exc), this.domain != null ? "Domain=" + this.domain + "; " : null, this.httpOnly ? "HttpOnly" : null, this.sameSite != null ? "SameSite=" + this.sameSite : null).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static String getSecureAttribute(Exchange exc) {
        Proxy proxy = exc.getProxy();
        if (!(proxy instanceof SSLableProxy)) {
            return null;
        }
        SSLableProxy sp = (SSLableProxy)proxy;
        return sp.isInboundSSL() ? "Secure" : null;
    }

    public List<String> createInvalidationAttributes() {
        return Stream.of("Expires=Thu, 01 Jan 1970 00:00:00 GMT", "Path=/", this.domain != null ? "Domain=" + this.domain + "; " : null).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<String> expireCookies(List<String> invalidCookies) {
        return invalidCookies.stream().map(cookie -> cookie + ";" + String.join((CharSequence)";", this.createInvalidationAttributes())).collect(Collectors.toList());
    }

    @Override
    public void store(Exchange exchange, Session session, String state, Exchange exchangeToStore) throws IOException {
        try {
            AbstractExchangeSnapshot trimmedAbstractExchangeSnapshot = this.getTrimmedAbstractExchangeSnapshot(exchangeToStore, 3000);
            FakeProxy r = trimmedAbstractExchangeSnapshot.getRule();
            String currentSessionCookieValue = this.originalRequestKeyNameInSession(state) + "=" + this.escapeForCookie(new ObjectMapper().writeValueAsString((Object)trimmedAbstractExchangeSnapshot));
            if (currentSessionCookieValue.length() > 4093) {
                log.warn("Cookie is larger than 4093 bytes, this will not work some browsers.");
            }
            exchange.getResponse().getHeader().add("Set-Cookie", currentSessionCookieValue + ";" + String.join((CharSequence)";", this.createCookieAttributes(exchange)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String escapeForCookie(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private String unescapeForCookie(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    protected Stream<String> getCookies(Exchange exc) {
        return exc.getRequest().getHeader().getValues(new HeaderName("Cookie")).stream().map(s -> s.getValue().split(";")).flatMap(Arrays::stream);
    }

    @Override
    public AbstractExchangeSnapshot reconstruct(Exchange exchange, Session session, String state) {
        try {
            String value = this.getCookies(exchange).filter(cookie -> cookie.indexOf("=") > 0).filter(cookie -> cookie.split("=")[0].trim().equals(this.originalRequestKeyNameInSession(state))).map(cookie -> cookie.split("=")[1]).map(cookie -> {
                int p = cookie.indexOf(59);
                if (p == -1) {
                    return cookie;
                }
                return cookie.substring(0, p);
            }).findFirst().get();
            return (AbstractExchangeSnapshot)new ObjectMapper().readValue(this.unescapeForCookie(value), AbstractExchangeSnapshot.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getStatesToRemove(Exchange exchange) {
        ArrayList<String> l = (ArrayList<String>)exchange.getProperty("statesToRemove");
        if (l != null) {
            return l;
        }
        l = new ArrayList<String>();
        exchange.setProperty("statesToRemove", l);
        return l;
    }

    @Override
    public void remove(Exchange exchange, Session session, String state) {
        this.getStatesToRemove(exchange).add(state);
    }

    @Override
    public void postProcess(Exchange exchange) {
        this.getStatesToRemove(exchange).forEach(state -> {
            String currentSessionCookieValue = this.originalRequestKeyNameInSession((String)state) + "=";
            this.expireCookies((List<String>)ImmutableList.of((Object)currentSessionCookieValue)).forEach(cookie -> exchange.getResponse().getHeader().add("Set-Cookie", (String)cookie));
        });
    }
}

