/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2client.LoginParameter;
import com.predic8.membrane.core.interceptor.oauth2client.OAuth2Resource2Interceptor;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="flowInitiator")
public class FlowInitiator
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)FlowInitiator.class.getName());
    private String triggerFlow;
    private String defaultFlow;
    private String afterLoginUrl;
    private OAuth2Resource2Interceptor oauth2;
    private List<LoginParameter> loginParameters = new ArrayList<LoginParameter>();
    private boolean logoutBeforeFlow = true;

    public String getTriggerFlow() {
        return this.triggerFlow;
    }

    @MCAttribute
    public void setTriggerFlow(String triggerFlow) {
        this.triggerFlow = triggerFlow;
    }

    public OAuth2Resource2Interceptor getOauth2() {
        return this.oauth2;
    }

    @MCAttribute
    public void setOauth2(OAuth2Resource2Interceptor oauth2) {
        this.oauth2 = oauth2;
    }

    public String getDefaultFlow() {
        return this.defaultFlow;
    }

    @MCAttribute
    public void setDefaultFlow(String defaultFlow) {
        this.defaultFlow = defaultFlow;
    }

    public String getAfterLoginUrl() {
        return this.afterLoginUrl;
    }

    @MCAttribute
    public void setAfterLoginUrl(String afterLoginUrl) {
        this.afterLoginUrl = afterLoginUrl;
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            return this.handleRequestInternal(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Error initiating OAuth2 flow!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    public Outcome handleRequestInternal(Exchange exc) throws Exception {
        List<HeaderField> values = null;
        if (this.logoutBeforeFlow) {
            exc.setResponse(Response.ok().build());
            this.oauth2.logOutSession(exc);
            values = exc.getResponse().getHeader().getValues(new HeaderName("Set-Cookie"));
            exc.getRequest().getHeader().removeFields("Cookie");
        }
        Map<String, String> params = URLParamUtil.getParams(new URIFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        exc.setProperty("loginParameters", LoginParameter.mergeParams(params, this.loginParameters));
        exc.getRequest().setUri(this.afterLoginUrl);
        exc.setOriginalRequestUri(this.afterLoginUrl);
        this.oauth2.respondWithRedirect(exc);
        Session session = this.oauth2.getSessionManager().getSession(exc);
        session.put("defaultFlow", this.defaultFlow);
        session.put("triggerFlow", this.triggerFlow);
        this.oauth2.getSessionManager().postProcess(exc);
        if (this.logoutBeforeFlow) {
            values.forEach(header -> exc.getResponse().getHeader().add((HeaderField)header));
        }
        String location = exc.getResponse().getHeader().getFirstValue("Location");
        location = location.replaceAll(this.defaultFlow, this.triggerFlow);
        exc.getResponse().getHeader().setValue("Location", location);
        return Outcome.RETURN;
    }

    public List<LoginParameter> getLoginParameters() {
        return this.loginParameters;
    }

    @MCChildElement
    public void setLoginParameters(List<LoginParameter> loginParameters) {
        this.loginParameters = loginParameters;
    }

    public boolean isLogoutBeforeFlow() {
        return this.logoutBeforeFlow;
    }

    @MCAttribute
    public void setLogoutBeforeFlow(boolean logoutBeforeFlow) {
        this.logoutBeforeFlow = logoutBeforeFlow;
    }
}

