/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.bornium.http.util.UriUtil;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@MCElement(name="loginParameter")
public class LoginParameter {
    private String name;
    private String value;

    public LoginParameter() {
    }

    public LoginParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static String copyLoginParameters(Exchange exc, List<LoginParameter> loginParameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (loginParameters.isEmpty()) {
            return sb.toString();
        }
        Map<String, String> params = URLParamUtil.getParams(new URIFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        loginParameters.forEach(lp -> {
            try {
                if (lp.getValue() != null) {
                    sb.append("&");
                    sb.append(lp.getName());
                    sb.append("=");
                    sb.append(UriUtil.encode((String)lp.getValue()));
                } else if (params.containsKey(lp.getName())) {
                    String encoded = UriUtil.encode((String)((String)params.get(lp.getName())));
                    sb.append("&");
                    sb.append(lp.getName());
                    sb.append("=");
                    sb.append(encoded);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        });
        return sb.toString();
    }

    public static List<LoginParameter> mergeParams(Map<String, String> params, List<LoginParameter> loginParameters) {
        List<LoginParameter> result = params.entrySet().stream().filter(entry -> loginParameters.stream().anyMatch(lp -> ((String)entry.getKey()).equals(lp.getName()))).map(entry -> new LoginParameter((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        loginParameters.stream().filter(lp -> lp.getValue() != null).forEach(lp -> {
            Optional<LoginParameter> resultLp = result.stream().filter(rlp -> rlp.getName().equals(lp.getName())).findFirst();
            if (resultLp.isPresent()) {
                resultLp.get().setValue(lp.getValue());
                return;
            }
            result.add((LoginParameter)lp);
        });
        return result;
    }

    public String getName() {
        return this.name;
    }

    @MCAttribute
    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    @MCAttribute
    public void setValue(String value) {
        this.value = value;
    }
}

