/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.interceptor.oauth2client.OriginalExchangeStore;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.util.MemcachedConnector;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.exception.MemcachedException;

@MCElement(name="memcachedOriginalExchangeStore")
public class MemcachedOriginalExchangeStore
extends OriginalExchangeStore {
    private int maxBodySize = 100000;
    private MemcachedConnector connector;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void store(Exchange exchange, Session session, String state, Exchange exchangeToStore) throws IOException {
        try {
            this.connector.getClient().set(state, 3600, (Object)this.objectMapper.writeValueAsString((Object)this.getTrimmedAbstractExchangeSnapshot(exchangeToStore, this.maxBodySize)));
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AbstractExchangeSnapshot reconstruct(Exchange exchange, Session session, String state) {
        try {
            String key = (String)this.connector.getClient().get(state);
            return (AbstractExchangeSnapshot)this.objectMapper.readValue(key, AbstractExchangeSnapshot.class);
        }
        catch (JsonProcessingException | InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove(Exchange exc, Session session, String state) {
        try {
            this.connector.getClient().delete(state);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void postProcess(Exchange exc) {
    }

    public int getMaxBodySize() {
        return this.maxBodySize;
    }

    @MCAttribute
    public void setMaxBodySize(int maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public MemcachedConnector getConnector() {
        return this.connector;
    }

    @MCAttribute
    public void setConnector(MemcachedConnector connector) {
        this.connector = connector;
    }
}

