/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptorWithSession;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AnswerParameters;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Statistics;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.interceptor.oauth2client.CookieOriginialExchangeStore;
import com.predic8.membrane.core.interceptor.oauth2client.LoginParameter;
import com.predic8.membrane.core.interceptor.oauth2client.OriginalExchangeStore;
import com.predic8.membrane.core.interceptor.oauth2client.rf.FormPostGenerator;
import com.predic8.membrane.core.interceptor.oauth2client.rf.OAuth2CallbackRequestHandler;
import com.predic8.membrane.core.interceptor.oauth2client.rf.OAuth2Exception;
import com.predic8.membrane.core.interceptor.oauth2client.rf.OAuthUtils;
import com.predic8.membrane.core.interceptor.oauth2client.rf.PublicUrlManager;
import com.predic8.membrane.core.interceptor.oauth2client.rf.SessionAuthorizer;
import com.predic8.membrane.core.interceptor.oauth2client.rf.StateManager;
import com.predic8.membrane.core.interceptor.oauth2client.rf.TokenAuthenticator;
import com.predic8.membrane.core.interceptor.oauth2client.rf.token.AccessTokenRefresher;
import com.predic8.membrane.core.interceptor.oauth2client.rf.token.AccessTokenRevalidator;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.URI;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="oauth2Resource2")
public class OAuth2Resource2Interceptor
extends AbstractInterceptorWithSession {
    private static final Logger log = LoggerFactory.getLogger((String)OAuth2Resource2Interceptor.class.getName());
    public static final String ERROR_STATUS = "oauth2-error-status";
    public static final String EXPECTED_AUDIENCE = "oauth2-expected-audience";
    public static final String WANTED_SCOPE = "oauth2-wanted-scope";
    private AuthorizationService auth;
    private OAuth2Statistics statistics;
    private URIFactory uriFactory;
    private OriginalExchangeStore originalExchangeStore;
    private String callbackPath = "oauth2callback";
    private final AccessTokenRevalidator accessTokenRevalidator = new AccessTokenRevalidator();
    private final AccessTokenRefresher accessTokenRefresher = new AccessTokenRefresher();
    private PublicUrlManager publicUrlManager = new PublicUrlManager();
    private final SessionAuthorizer sessionAuthorizer = new SessionAuthorizer();
    private final OAuth2CallbackRequestHandler oAuth2CallbackRequestHandler = new OAuth2CallbackRequestHandler();
    private final TokenAuthenticator tokenAuthenticator = new TokenAuthenticator();
    private String customHeaderUserPropertyPrefix;
    private String logoutUrl;
    private String afterLogoutUrl = "/";
    private String afterErrorUrl = null;
    private List<LoginParameter> loginParameters = new ArrayList<LoginParameter>();
    private boolean appendAccessTokenToRequest;
    private boolean onlyRefreshToken = false;

    @Override
    public void init() {
        super.init();
        this.name = "oauth2 client";
        this.setFlow(Interceptor.Flow.Set.REQUEST_RESPONSE_ABORT_FLOW);
        if (this.originalExchangeStore == null) {
            this.originalExchangeStore = new CookieOriginialExchangeStore();
        }
        try {
            this.auth.init(this.router);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not init auth in OAuth2Resource2Interceptor", e);
        }
        this.statistics = new OAuth2Statistics();
        this.uriFactory = this.router.getUriFactory();
        this.publicUrlManager.init(this.auth, this.callbackPath);
        this.accessTokenRevalidator.init(this.auth, this.statistics);
        this.accessTokenRefresher.init(this.auth, this.onlyRefreshToken);
        this.sessionAuthorizer.init(this.auth, this.router, this.statistics);
        this.oAuth2CallbackRequestHandler.init(this.uriFactory, this.auth, this.originalExchangeStore, this.accessTokenRevalidator, this.sessionAuthorizer, this.publicUrlManager, this.callbackPath, this.onlyRefreshToken);
        this.tokenAuthenticator.init(this.sessionAuthorizer, this.statistics, this.accessTokenRevalidator, this.auth);
    }

    @Override
    protected Outcome handleResponseInternal(Exchange exc) {
        return Outcome.CONTINUE;
    }

    @Override
    public final Outcome handleRequestInternal(Exchange exc) throws Exception {
        String wantedScope;
        Session session = this.getSessionManager().getSession(exc);
        if (this.isLogoutBackRequest(exc)) {
            exc.setResponse(Response.redirect(this.afterLogoutUrl, false).status(303).build());
            this.logOutSession(exc);
            return Outcome.RETURN;
        }
        if (this.isLogoutRequest(exc)) {
            String endSessionEndpoint = this.auth.getEndSessionEndpoint();
            if (endSessionEndpoint != null && session.getOAuth2Answer(null) != null) {
                String redirectUri = this.logoutUrl;
                redirectUri = this.replaceUrlPath(this.publicUrlManager.getPublicURL(exc), redirectUri + "/back");
                String uri = endSessionEndpoint + "?post_logout_redirect_uri=" + URLEncoder.encode(redirectUri, StandardCharsets.UTF_8);
                OAuth2AnswerParameters ap = session.getOAuth2AnswerParameters();
                if (ap != null && ap.getIdToken() != null) {
                    uri = uri + "&id_token_hint=" + ap.getIdToken();
                }
                exc.setResponse(Response.redirect(uri, false).status(303).build());
            } else {
                exc.setResponse(Response.redirect(this.afterLogoutUrl, false).status(303).build());
            }
            this.logOutSession(exc);
            return Outcome.RETURN;
        }
        if (this.isFaviconRequest(exc)) {
            exc.setResponse(Response.badRequest().build());
            return Outcome.RETURN;
        }
        OAuthUtils.simplifyMultipleOAuth2Answers(session);
        if (OAuthUtils.isOAuth2RedirectRequest(exc)) {
            this.handleOriginalRequest(exc);
        }
        if (this.tokenAuthenticator.userInfoIsNullAndShouldRedirect(session, exc, wantedScope = (String)exc.getProperty(WANTED_SCOPE))) {
            return this.respondWithRedirect(exc);
        }
        this.accessTokenRevalidator.revalidateIfNeeded(session, wantedScope);
        if (session.hasOAuth2Answer(wantedScope)) {
            exc.setProperty("membrane.oauth2", session.getOAuth2AnswerParameters(wantedScope));
        }
        this.accessTokenRefresher.refreshIfNeeded(session, exc);
        try {
            boolean wasCallback = this.handleRequest(exc, session);
            if (!wasCallback && session.isVerified()) {
                this.applyBackendAuthorization(exc, session);
                this.statistics.successfulRequest();
                this.appendAccessTokenToRequest(exc);
                return Outcome.CONTINUE;
            }
            if (wasCallback) {
                if (exc.getResponse() == null && exc.getRequest() != null && session.isVerified() && session.hasOAuth2Answer()) {
                    exc.setProperty("membrane.oauth2", session.getOAuth2AnswerParameters(wantedScope));
                    this.appendAccessTokenToRequest(exc);
                    return Outcome.CONTINUE;
                }
                if (exc.getResponse().getStatusCode() >= 400) {
                    session.clear();
                }
                return Outcome.RETURN;
            }
            log.debug("session present, but not verified, redirecting.");
            return this.respondWithRedirect(exc);
        }
        catch (OAuth2Exception e) {
            session.clear();
            if (this.afterErrorUrl != null) {
                FormPostGenerator fpg = new FormPostGenerator(this.afterErrorUrl).withParameter("error", e.getError());
                if (e.getErrorDescription() != null) {
                    fpg.withParameter("error_description", e.getErrorDescription());
                }
                exc.setResponse(fpg.build());
            } else {
                exc.setResponse(e.getResponse());
            }
            return Outcome.RETURN;
        }
    }

    private String replaceUrlPath(String url, String newPath) {
        URI uri = this.router.getUriFactory().createWithoutException(url);
        return uri.getScheme() + "://" + uri.getHost() + (String)(uri.getPort() != -1 ? ":" + uri.getPort() : "") + newPath;
    }

    private void handleOriginalRequest(Exchange exc) throws Exception {
        Map<String, String> params = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        String oa2redirect = params.get("oa2redirect");
        Session session = this.getSessionManager().getSession(exc);
        AbstractExchange originalExchange = ((AbstractExchangeSnapshot)new ObjectMapper().readValue(session.get(OAuthUtils.oa2redictKeyNameInSession(oa2redirect)).toString(), AbstractExchangeSnapshot.class)).toAbstractExchange();
        session.remove(OAuthUtils.oa2redictKeyNameInSession(oa2redirect));
        this.doOriginalRequest(exc, originalExchange);
    }

    private boolean isLogoutRequest(Exchange exc) {
        return this.logoutUrl != null && exc.getRequestURI().startsWith(this.logoutUrl);
    }

    private boolean isLogoutBackRequest(Exchange exc) {
        return this.logoutUrl != null && exc.getRequestURI().startsWith(this.logoutUrl + "/back");
    }

    public void logOutSession(Exchange exc) {
        Session session = this.getSessionManager().getSession(exc);
        session.clear();
        this.getSessionManager().removeSession(exc);
        exc.getProperties().remove("SESSION");
        exc.getProperties().remove("SESSION_COOKIE_ORIGINAL");
    }

    private boolean isFaviconRequest(Exchange exc) {
        return exc.getRequestURI().startsWith("/favicon.ico");
    }

    private void applyBackendAuthorization(Exchange exc, Session s) {
        if (this.customHeaderUserPropertyPrefix == null) {
            return;
        }
        Header h = exc.getRequest().getHeader();
        for (Map.Entry<String, Object> e : s.get().entrySet()) {
            if (!e.getKey().startsWith(this.customHeaderUserPropertyPrefix)) continue;
            String headerName = e.getKey().substring(this.customHeaderUserPropertyPrefix.length());
            h.removeFields(headerName);
            h.add(headerName, e.getValue().toString());
        }
    }

    public Outcome respondWithRedirect(Exchange exc) throws Exception {
        Integer errorStatus = (Integer)exc.getProperty(ERROR_STATUS);
        if (errorStatus != null) {
            exc.setResponse(Response.statusCode(errorStatus).header("Content-Length", "0").build());
            return Outcome.RETURN;
        }
        Object state = StateManager.generateNewState();
        Map lps = this.loginParameters.stream().collect(HashMap::new, (m, lp) -> m.put(lp.getName(), lp.getValue()), HashMap::putAll);
        Optional.ofNullable((List)exc.getProperty("loginParameters")).orElse(List.of()).forEach(lp -> lps.put(lp.getName(), lp.getValue()));
        List<LoginParameter> combinedLoginParameters = lps.entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            return !"client_id".equals(key) && !"response_type".equals(key) && !"scope".equals(key) && !"redirect_uri".equals(key) && !"response_mode".equals(key) && !"state".equals(key) && !"claims".equals(key);
        }).map(e -> new LoginParameter((String)e.getKey(), (String)e.getValue())).toList();
        exc.setResponse(Response.redirect(this.auth.getLoginURL((String)state, this.publicUrlManager.getPublicURL(exc) + this.callbackPath, exc.getRequestURI()) + LoginParameter.copyLoginParameters(exc, combinedLoginParameters), false).build());
        this.readBodyFromStreamIntoMemory(exc);
        Session session = this.getSessionManager().getSession(exc);
        this.originalExchangeStore.store(exc, session, (String)state, exc);
        if (session.get().containsKey("state")) {
            state = String.valueOf(session.get("state")) + "," + (String)state;
        }
        session.put("state", state);
        return Outcome.RETURN;
    }

    private void readBodyFromStreamIntoMemory(Exchange exc) {
        exc.getRequest().getBodyAsStringDecoded();
    }

    private boolean handleRequest(Exchange exc, Session session) throws Exception {
        String path = this.uriFactory.create(exc.getDestinations().getFirst()).getPath();
        if (path == null) {
            return false;
        }
        if (path.endsWith("/" + this.callbackPath)) {
            return this.oAuth2CallbackRequestHandler.handleRequest(exc, session);
        }
        return false;
    }

    private void doOriginalRequest(Exchange exc, AbstractExchange originalRequest) {
        originalRequest.getRequest().getHeader().add("Cookie", exc.getRequest().getHeader().getFirstValue("Cookie"));
        exc.setRequest(originalRequest.getRequest());
        exc.getDestinations().clear();
        String xForwardedProto = originalRequest.getRequest().getHeader().getFirstValue("X-Forwarded-Proto");
        String xForwardedHost = originalRequest.getRequest().getHeader().getFirstValue("X-Forwarded-Host");
        String originalRequestUri = originalRequest.getOriginalRequestUri();
        exc.getDestinations().add(xForwardedProto + "://" + xForwardedHost + originalRequestUri);
        exc.setOriginalRequestUri(originalRequestUri);
        exc.setOriginalHostHeader(xForwardedHost);
    }

    private void appendAccessTokenToRequest(Exchange exc) {
        if (!this.appendAccessTokenToRequest) {
            return;
        }
        if (exc.getProperty("membrane.oauth2") == null) {
            return;
        }
        OAuth2AnswerParameters params = (OAuth2AnswerParameters)exc.getProperty("membrane.oauth2");
        if (params.getAccessToken() == null) {
            return;
        }
        exc.getRequest().getHeader().setValue("Authorization", "Bearer " + params.getAccessToken());
    }

    @Override
    public String getShortDescription() {
        return "Client of the oauth2 authentication process.\n" + this.statistics.toString();
    }

    public OriginalExchangeStore getOriginalExchangeStore() {
        return this.originalExchangeStore;
    }

    @MCChildElement(order=20, allowForeign=true)
    public void setOriginalExchangeStore(OriginalExchangeStore originalExchangeStore) {
        this.originalExchangeStore = originalExchangeStore;
    }

    public boolean isSkipUserInfo() {
        return this.sessionAuthorizer.isSkipUserInfo();
    }

    @MCAttribute
    public void setSkipUserInfo(boolean skipUserInfo) {
        this.sessionAuthorizer.setSkipUserInfo(skipUserInfo);
    }

    @MCChildElement(order=5)
    public void setPublicUrlManager(PublicUrlManager publicUrlManager) {
        this.publicUrlManager = publicUrlManager;
    }

    public PublicUrlManager getPublicUrlManager() {
        return this.publicUrlManager;
    }

    public AuthorizationService getAuthService() {
        return this.auth;
    }

    @MCChildElement(order=10)
    @Required
    public void setAuthService(AuthorizationService auth) {
        this.auth = auth;
    }

    public int getRevalidateTokenAfter() {
        return this.accessTokenRevalidator.getRevalidateTokenAfter();
    }

    @MCAttribute
    public void setRevalidateTokenAfter(int revalidateTokenAfter) {
        this.accessTokenRevalidator.setRevalidateTokenAfter(revalidateTokenAfter);
    }

    public String getCallbackPath() {
        return this.callbackPath;
    }

    @MCAttribute
    public void setCallbackPath(String callbackPath) {
        this.callbackPath = callbackPath;
    }

    public String getCustomHeaderUserPropertyPrefix() {
        return this.customHeaderUserPropertyPrefix;
    }

    @MCAttribute
    public void setCustomHeaderUserPropertyPrefix(String customHeaderUserPropertyPrefix) {
        this.customHeaderUserPropertyPrefix = customHeaderUserPropertyPrefix;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    @MCAttribute
    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getAfterLogoutUrl() {
        return this.afterLogoutUrl;
    }

    @MCAttribute
    public void setAfterLogoutUrl(String afterLogoutUrl) {
        this.afterLogoutUrl = afterLogoutUrl;
    }

    public List<LoginParameter> getLoginParameters() {
        return this.loginParameters;
    }

    @MCChildElement(order=25)
    public void setLoginParameters(List<LoginParameter> loginParameters) {
        this.loginParameters = loginParameters;
    }

    public boolean isAppendAccessTokenToRequest() {
        return this.appendAccessTokenToRequest;
    }

    @MCAttribute
    public void setAppendAccessTokenToRequest(boolean appendAccessTokenToRequest) {
        this.appendAccessTokenToRequest = appendAccessTokenToRequest;
    }

    public String getAfterErrorUrl() {
        return this.afterErrorUrl;
    }

    @MCAttribute
    public void setAfterErrorUrl(String afterErrorUrl) {
        this.afterErrorUrl = afterErrorUrl;
    }

    public boolean isOnlyRefreshToken() {
        return this.onlyRefreshToken;
    }

    @MCAttribute
    public void setOnlyRefreshToken(boolean onlyRefreshToken) {
        this.onlyRefreshToken = onlyRefreshToken;
    }
}

