/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.jwt.Jwks;
import com.predic8.membrane.core.interceptor.jwt.JwtAuthInterceptor;
import com.predic8.membrane.core.interceptor.oauth2client.OAuth2Resource2Interceptor;
import com.predic8.membrane.core.util.ConfigurationException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="requireAuth")
public class RequireAuth
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)RequireAuth.class.getName());
    private String expectedAud;
    private OAuth2Resource2Interceptor oauth2;
    private JwtAuthInterceptor jwtAuth;
    private boolean required = true;
    private Integer errorStatus = null;
    private String scope = null;

    @Override
    public void init() {
        super.init();
        Jwks jwks = new Jwks();
        jwks.setJwks(new ArrayList<Jwks.Jwk>());
        try {
            jwks.setJwksUris(this.oauth2.getAuthService().getJwksEndpoint());
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not set jwks Uris.", e);
        }
        jwks.setAuthorizationService(this.oauth2.getAuthService());
        this.jwtAuth = new JwtAuthInterceptor();
        this.jwtAuth.setJwks(jwks);
        this.jwtAuth.setExpectedAud(this.expectedAud);
        this.jwtAuth.init(this.router);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        if (!this.isBearer(exc.getRequest().getHeader())) {
            if (this.errorStatus != null) {
                exc.setProperty("oauth2-error-status", this.errorStatus);
            }
            exc.setProperty("oauth2-expected-audience", this.expectedAud);
            exc.setProperty("oauth2-wanted-scope", this.scope);
            Outcome outcome = this.oauth2.handleRequest(exc);
            if (outcome != Outcome.CONTINUE) {
                if (!this.required) {
                    return Outcome.CONTINUE;
                }
                return outcome;
            }
        }
        return this.jwtAuth.handleRequest(exc);
    }

    private boolean isBearer(Header header) {
        return header.contains("Authorization") && header.getFirstValue("Authorization").startsWith("Bearer");
    }

    public String getExpectedAud() {
        return this.expectedAud;
    }

    @MCAttribute
    @Required
    public void setExpectedAud(String expectedAud) {
        this.expectedAud = expectedAud;
        if (this.jwtAuth != null) {
            this.jwtAuth.setExpectedAud(expectedAud);
        }
    }

    public OAuth2Resource2Interceptor getOauth2() {
        return this.oauth2;
    }

    @MCAttribute
    @Required
    public void setOauth2(OAuth2Resource2Interceptor oauth2) {
        this.oauth2 = oauth2;
    }

    @MCAttribute
    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Integer getErrorStatus() {
        return this.errorStatus;
    }

    @MCAttribute
    public void setErrorStatus(int errorStatus) {
        this.errorStatus = errorStatus;
    }

    public String getScope() {
        return this.scope;
    }

    @MCAttribute
    public void setScope(String scope) {
        this.scope = scope;
    }
}

