/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client.rf;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AnswerParameters;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.interceptor.oauth2client.OriginalExchangeStore;
import com.predic8.membrane.core.interceptor.oauth2client.rf.JsonUtils;
import com.predic8.membrane.core.interceptor.oauth2client.rf.LogHelper;
import com.predic8.membrane.core.interceptor.oauth2client.rf.OAuth2Exception;
import com.predic8.membrane.core.interceptor.oauth2client.rf.OAuthUtils;
import com.predic8.membrane.core.interceptor.oauth2client.rf.PublicUrlManager;
import com.predic8.membrane.core.interceptor.oauth2client.rf.SessionAuthorizer;
import com.predic8.membrane.core.interceptor.oauth2client.rf.StateManager;
import com.predic8.membrane.core.interceptor.oauth2client.rf.token.AccessTokenRevalidator;
import com.predic8.membrane.core.interceptor.oauth2client.rf.token.TokenResponseHandler;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2CallbackRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuth2CallbackRequestHandler.class);
    LogHelper logHelper = new LogHelper();
    private URIFactory uriFactory;
    private AuthorizationService auth;
    private OriginalExchangeStore originalExchangeStore;
    private AccessTokenRevalidator accessTokenRevalidator;
    private SessionAuthorizer sessionAuthorizer;
    private PublicUrlManager publicUrlManager;
    private TokenResponseHandler tokenResponseHandler;
    private String callbackPath;
    private boolean onlyRefreshToken;

    public void init(URIFactory uriFactory, AuthorizationService auth, OriginalExchangeStore originalExchangeStore, AccessTokenRevalidator accessTokenRevalidator, SessionAuthorizer sessionAuthorizer, PublicUrlManager publicUrlManager, String callbackPath, boolean onlyRefreshToken) {
        this.uriFactory = uriFactory;
        this.auth = auth;
        this.originalExchangeStore = originalExchangeStore;
        this.accessTokenRevalidator = accessTokenRevalidator;
        this.sessionAuthorizer = sessionAuthorizer;
        this.publicUrlManager = publicUrlManager;
        this.callbackPath = callbackPath;
        this.onlyRefreshToken = onlyRefreshToken;
        this.tokenResponseHandler = new TokenResponseHandler();
        this.tokenResponseHandler.init(auth);
        if (onlyRefreshToken && !sessionAuthorizer.isSkipUserInfo()) {
            throw new RuntimeException("If onlyRefreshToken is set, skipUserInfo also has to be set.");
        }
    }

    public boolean handleRequest(Exchange exc, Session session) throws Exception {
        try {
            Map<String, Object> json;
            Map<String, String> params = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
            String state2 = params.get("state");
            String stateFromUri = StateManager.getSecurityTokenFromState(state2);
            if (!StateManager.csrfTokenMatches(session, stateFromUri)) {
                throw new RuntimeException("CSRF token mismatch.");
            }
            session.put("state", stateFromUri);
            AbstractExchangeSnapshot originalRequest = this.originalExchangeStore.reconstruct(exc, session, stateFromUri);
            this.originalExchangeStore.remove(exc, session, stateFromUri);
            if (log.isDebugEnabled()) {
                log.debug("CSRF token match.");
            }
            String tokenEndpoint = this.auth.getTokenEndpoint();
            if (session.get("defaultFlow") != null) {
                tokenEndpoint = tokenEndpoint.replaceAll((String)session.get("defaultFlow"), (String)session.get("triggerFlow"));
            }
            if (!(json = this.exchangeCodeForToken(tokenEndpoint, this.publicUrlManager.getPublicURL(exc), params)).containsKey("access_token")) {
                if (!this.onlyRefreshToken) {
                    throw new RuntimeException("No access_token received.");
                }
                String idToken = (String)json.get("id_token");
                OAuth2AnswerParameters oauth2Answer = new OAuth2AnswerParameters();
                this.tokenResponseHandler.handleTokenResponse(session, null, json, oauth2Answer);
                this.sessionAuthorizer.verifyJWT(exc, idToken, oauth2Answer, session);
            } else {
                String token = (String)json.get("access_token");
                if (token == null) {
                    throw new RuntimeException("OAuth2 response with access_token set to null.");
                }
                this.accessTokenRevalidator.getValidTokens().put((Object)token, (Object)true);
                OAuth2AnswerParameters oauth2Answer = new OAuth2AnswerParameters();
                this.tokenResponseHandler.handleTokenResponse(session, null, json, oauth2Answer);
                if (!this.sessionAuthorizer.isSkipUserInfo()) {
                    this.sessionAuthorizer.retrieveUserInfo(json.get("token_type").toString(), token, oauth2Answer, session);
                } else {
                    this.sessionAuthorizer.verifyJWT(exc, token, oauth2Answer, session);
                }
            }
            OAuth2CallbackRequestHandler.continueOriginalExchange(exc, originalRequest, session);
            this.originalExchangeStore.postProcess(exc);
            return true;
        }
        catch (OAuth2Exception e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Could not exchange code for token.", (Throwable)e);
            exc.setResponse(Response.badRequest().body(e.getMessage()).build());
            this.originalExchangeStore.postProcess(exc);
            return true;
        }
    }

    private Map<String, Object> exchangeCodeForToken(String tokenEndpoint, String publicUrl, Map<String, String> params) throws Exception {
        String code = params.get("code");
        if (code == null) {
            String error = params.get("error");
            if (error != null) {
                log.warn("OAuth2 Error from Authentication Server: {}", (Object)error);
                ProblemDetails pd = ProblemDetails.security(false, "oauth2-callback-request-handler").title("OAuth2 Error from Authentication Server").statusCode(500).addSubSee("oauth2-error-from-authentication-server").detail(params.get("error_description")).internal("error", error);
                throw new OAuth2Exception(error, params.get("error_description"), pd.build());
            }
            throw new RuntimeException("No code received.");
        }
        Exchange e = this.auth.applyAuth(new Request.Builder().post(tokenEndpoint).contentType("application/x-www-form-urlencoded").header("Accept", "application/json").header("User-Agent", Constants.USERAGENT), "code=" + code + "&redirect_uri=" + publicUrl + this.callbackPath + "&grant_type=authorization_code").buildExchange();
        this.logHelper.handleRequest(e);
        Response response = this.auth.doRequest(e);
        this.logHelper.handleResponse(e);
        if (response.getStatusCode() != 200) {
            response.getBody().read();
            throw new RuntimeException("Authorization server returned " + response.getStatusCode() + ".");
        }
        if (!JsonUtils.isJson(response)) {
            throw new RuntimeException("Token response is no JSON.");
        }
        return (Map)new ObjectMapper().readValue(response.getBodyAsStreamDecoded(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
    }

    private static void continueOriginalExchange(Exchange exc, AbstractExchangeSnapshot originalRequest, Session session) throws Exception {
        if (originalRequest.getRequest().getMethod().equals("GET")) {
            exc.setResponse(Response.redirect(originalRequest.getOriginalRequestUri(), false).build());
        } else {
            String oa2redirect = new BigInteger(130, new SecureRandom()).toString(32);
            session.put(OAuthUtils.oa2redictKeyNameInSession(oa2redirect), new ObjectMapper().writeValueAsString((Object)originalRequest));
            String delimiter = originalRequest.getOriginalRequestUri().contains("?") ? "&" : "?";
            exc.setResponse(Response.redirect(originalRequest.getOriginalRequestUri() + delimiter + "oa2redirect=" + oa2redirect, false).build());
        }
    }
}

