/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client.rf;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.session.Session;
import java.util.Optional;
import javax.annotation.Nullable;

public class OAuthUtils {
    public static void simplifyMultipleOAuth2Answers(@Nullable Session session) {
        Optional.ofNullable(session).filter(sess -> sess.get("oauth2Answer") != null).map(sess -> sess.get("oauth2Answer").toString()).ifPresent(answer -> OAuthUtils.keepOnlyFirstOAuthAnswer(session, answer));
    }

    private static void keepOnlyFirstOAuthAnswer(Session session, String answer) {
        int indexOfTopLevelComma = OAuthUtils.getIndexOfTopLevelComma(answer);
        if (indexOfTopLevelComma < 0) {
            return;
        }
        session.put("oauth2Answer", answer.substring(0, indexOfTopLevelComma));
    }

    private static int getIndexOfTopLevelComma(String answer) {
        int curlyBraceLevel = 0;
        boolean inString = false;
        boolean escapeNext = false;
        block10: for (int i = 0; i < answer.length(); ++i) {
            if (escapeNext) {
                escapeNext = false;
                continue;
            }
            char c = answer.charAt(i);
            if (inString) {
                switch (c) {
                    case '\"': {
                        inString = false;
                        break;
                    }
                    case '\\': {
                        escapeNext = true;
                    }
                }
                continue;
            }
            switch (c) {
                case '{': {
                    ++curlyBraceLevel;
                    continue block10;
                }
                case '}': {
                    --curlyBraceLevel;
                    continue block10;
                }
                case ',': {
                    if (curlyBraceLevel != 0) continue block10;
                    return i;
                }
                case '\"': {
                    inString = true;
                }
            }
        }
        return -1;
    }

    public static boolean isOAuth2RedirectRequest(Exchange exc) {
        return exc.getOriginalRequestUri().contains("oa2redirect");
    }

    public static String oa2redictKeyNameInSession(String oa2redirect) {
        return "_redirect_for_oa2redirect_" + oa2redirect;
    }
}

