/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client.rf;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.proxies.RuleKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;

@MCElement(name="publicURL")
public class PublicUrlManager {
    @GuardedBy(value="publicURLs")
    private final List<String> publicURLs = new ArrayList<String>();
    private boolean initPublicURLsOnTheFly = false;
    private boolean firstInitWhenDynamicAuthorizationService;
    private AuthorizationService auth;
    private String callbackPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AuthorizationService auth, String callbackPath) {
        this.auth = auth;
        this.callbackPath = callbackPath;
        List<String> list = this.publicURLs;
        synchronized (list) {
            if (this.publicURLs.isEmpty()) {
                this.initPublicURLsOnTheFly = true;
            } else {
                this.publicURLs.replaceAll(this::normalizePublicURL);
            }
        }
        this.firstInitWhenDynamicAuthorizationService = auth.supportsDynamicRegistration();
        if (!auth.supportsDynamicRegistration()) {
            this.firstInitWhenDynamicAuthorizationService = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublicURL() {
        List<String> list = this.publicURLs;
        synchronized (list) {
            return String.join((CharSequence)" ", this.publicURLs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MCAttribute
    public void setPublicURL(String publicURL) {
        List<String> list = this.publicURLs;
        synchronized (list) {
            this.publicURLs.clear();
            Collections.addAll(this.publicURLs, publicURL.split("[ \t]+"));
        }
    }

    public String normalizePublicURL(String url) {
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublicURL(Exchange exc) throws Exception {
        Object publicURL = OAuth2Util.getPublicURL(exc);
        RuleKey key = exc.getProxy().getKey();
        if (!key.isPathRegExp() && key.getPath() != null) {
            publicURL = (String)publicURL + key.getPath();
        }
        publicURL = this.normalizePublicURL((String)publicURL);
        List<String> list = this.publicURLs;
        synchronized (list) {
            if (this.publicURLs.contains(publicURL)) {
                return publicURL;
            }
            if (!this.initPublicURLsOnTheFly) {
                return this.publicURLs.getFirst();
            }
        }
        if (this.firstInitWhenDynamicAuthorizationService && this.addPublicURL((String)publicURL) != null) {
            this.auth.dynamicRegistration(this.getPublicURLs().stream().map(url -> url + this.callbackPath).collect(Collectors.toList()));
        }
        return publicURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addPublicURL(String publicURL) {
        List<String> list = this.publicURLs;
        synchronized (list) {
            if (this.publicURLs.contains(publicURL)) {
                return null;
            }
            this.publicURLs.add(publicURL);
        }
        return publicURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPublicURLs() {
        List<String> list = this.publicURLs;
        synchronized (list) {
            return new ArrayList<String>(this.publicURLs);
        }
    }
}

