/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client.rf;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.jwt.Jwks;
import com.predic8.membrane.core.interceptor.jwt.JwtAuthInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AnswerParameters;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Statistics;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.interceptor.oauth2client.rf.JsonUtils;
import com.predic8.membrane.core.interceptor.oauth2client.rf.LogHelper;
import com.predic8.membrane.core.interceptor.session.Session;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(SessionAuthorizer.class);
    LogHelper logHelper = new LogHelper();
    private JwtAuthInterceptor jwtAuthInterceptor;
    private boolean skip;
    private AuthorizationService auth;
    private Router router;
    private OAuth2Statistics statistics;

    public void init(AuthorizationService auth, Router router, OAuth2Statistics statistics) {
        this.auth = auth;
        this.router = router;
        this.statistics = statistics;
        if (this.skip) {
            try {
                this.jwtAuthInterceptor = this.createJwtAuthInterceptor();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isSkipUserInfo() {
        return this.skip;
    }

    public void setSkipUserInfo(boolean skip) {
        this.skip = skip;
    }

    public void authorizeSession(Map<String, Object> userInfo, Session session, AuthorizationService auth) {
        if (!userInfo.containsKey(auth.getSubject())) {
            throw new RuntimeException("User object does not contain " + auth.getSubject() + " key.");
        }
        Map<String, Object> userAttributes = session.get();
        String userIdPropertyFixed = auth.getSubject().substring(0, 1).toUpperCase() + auth.getSubject().substring(1);
        String username = (String)userInfo.get(auth.getSubject());
        userAttributes.put("headerX-Authenticated-" + userIdPropertyFixed, username);
        session.authorize(username);
    }

    public JwtAuthInterceptor getJwtAuthInterceptor() {
        return this.jwtAuthInterceptor;
    }

    private JwtAuthInterceptor createJwtAuthInterceptor() throws Exception {
        JwtAuthInterceptor jwtAuthInterceptor = new JwtAuthInterceptor();
        jwtAuthInterceptor.setJwks(this.createJwks());
        jwtAuthInterceptor.setExpectedAud("any!!");
        jwtAuthInterceptor.init(this.router);
        return jwtAuthInterceptor;
    }

    private Jwks createJwks() throws Exception {
        Jwks jwks = new Jwks();
        jwks.setJwks(new ArrayList<Jwks.Jwk>());
        jwks.setJwksUris(this.auth.getJwksEndpoint());
        jwks.setAuthorizationService(this.auth);
        return jwks;
    }

    public void retrieveUserInfo(String tokenType, String token, OAuth2AnswerParameters oauth2Answer, Session session) throws Exception {
        Exchange e2 = new Request.Builder().get(this.auth.getUserInfoEndpoint()).header("Authorization", tokenType + " " + token).header("User-Agent", Constants.USERAGENT).header("Accept", "application/json").buildExchange();
        this.logHelper.handleRequest(e2);
        Response response2 = this.auth.doRequest(e2);
        this.logHelper.handleResponse(e2);
        if (response2.getStatusCode() != 200) {
            this.statistics.accessTokenInvalid();
            throw new RuntimeException("User data could not be retrieved.");
        }
        this.statistics.accessTokenValid();
        if (!JsonUtils.isJson(response2)) {
            throw new RuntimeException("Userinfo response is no JSON.");
        }
        Map json2 = (Map)new ObjectMapper().readValue(response2.getBodyAsStreamDecoded(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        oauth2Answer.setUserinfo(json2);
        this.authorizeSession(json2, session, this.auth);
        session.put("oauth2Answer", oauth2Answer.serialize());
    }

    public void verifyJWT(Exchange exc, String token, OAuth2AnswerParameters oauth2Answer, Session session) throws Exception {
        session.put("oauth2Answer", oauth2Answer.serialize());
        if (this.getJwtAuthInterceptor().handleJwt(exc, token) != Outcome.CONTINUE) {
            throw new RuntimeException("Access token is not a JWT.");
        }
        this.authorizeSession((Map)exc.getProperty("jwt"), session, this.auth);
    }
}

