/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client.rf;

import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.util.URLParamUtil;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class StateManager {
    private static final SecureRandom sr = new SecureRandom();

    @NotNull
    public static String generateNewState() {
        return new BigInteger(130, sr).toString(32);
    }

    public static String getSecurityTokenFromState(String state2) {
        if (state2 == null) {
            throw new RuntimeException("No CSRF token.");
        }
        Map<String, String> param = URLParamUtil.parseQueryString(URLDecoder.decode(state2, StandardCharsets.UTF_8), URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        if (!param.containsKey("security_token")) {
            throw new RuntimeException("No CSRF token.");
        }
        return param.get("security_token");
    }

    public static boolean csrfTokenMatches(Session session, String state2) {
        return Optional.ofNullable(session.get("state")).filter(o -> Arrays.stream(o.toString().split(",")).filter(s -> s.equals(state2)).count() == 1L).isPresent();
    }
}

