/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client.rf.token;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AnswerParameters;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.interceptor.oauth2client.rf.JsonUtils;
import com.predic8.membrane.core.interceptor.oauth2client.rf.token.TokenResponseHandler;
import com.predic8.membrane.core.interceptor.session.Session;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenRefresher {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenRefresher.class);
    private final Cache<String, Object> synchronizers = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private AuthorizationService auth;
    private TokenResponseHandler tokenResponseHandler;
    private boolean onlyRefreshToken;

    public void init(AuthorizationService auth, boolean onlyRefreshToken) {
        this.auth = auth;
        this.onlyRefreshToken = onlyRefreshToken;
        this.tokenResponseHandler = new TokenResponseHandler();
        this.tokenResponseHandler.init(auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIfNeeded(Session session, Exchange exc) {
        String wantedScope = (String)exc.getProperty("oauth2-wanted-scope");
        if (!this.refreshingOfAccessTokenIsNeeded(session, wantedScope)) {
            return;
        }
        Object object = this.getTokenSynchronizer(session);
        synchronized (object) {
            try {
                exc.setProperty("membrane.oauth2", this.refreshAccessToken(session, wantedScope));
            }
            catch (Exception e) {
                log.warn("Failed to refresh access token, clearing session and restarting OAuth2 flow.", (Throwable)e);
                session.clearAuthentication();
            }
        }
    }

    private OAuth2AnswerParameters refreshAccessToken(Session session, String wantedScope) throws Exception {
        OAuth2AnswerParameters params = session.getOAuth2AnswerParameters();
        Response response = this.auth.refreshTokenRequest(session, params, wantedScope);
        if (!response.isOk()) {
            response.getBody().read();
            throw new RuntimeException("Statuscode from authorization server for refresh token request: " + response.getStatusCode());
        }
        if (!JsonUtils.isJson(response)) {
            throw new RuntimeException("Refresh Token response is no JSON.");
        }
        Map json = (Map)new ObjectMapper().readValue(response.getBodyAsStreamDecoded(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        if (!this.onlyRefreshToken && this.isMissingOneToken(json)) {
            response.getBody().read();
            throw new RuntimeException("Statuscode was ok but no access_token and refresh_token was received: " + response.getStatusCode());
        }
        this.tokenResponseHandler.handleTokenResponse(session, wantedScope, json, params);
        session.setOAuth2Answer(wantedScope, params.serialize());
        return params;
    }

    private boolean refreshingOfAccessTokenIsNeeded(Session session, String wantedScope) {
        if (session.getOAuth2Answer(wantedScope) == null) {
            return wantedScope != null && session.getOAuth2Answer() != null;
        }
        if (session.getAccessToken(wantedScope) == null && wantedScope != null) {
            return true;
        }
        OAuth2AnswerParameters params = session.getOAuth2AnswerParameters(wantedScope);
        OAuth2AnswerParameters rparams = session.getOAuth2AnswerParameters();
        String expiration = params.getExpiration();
        if (this.isNullOrEmpty(rparams.getRefreshToken(), expiration)) {
            return false;
        }
        LocalDateTime expirationTime = params.getReceivedAt().plusSeconds(Long.parseLong(expiration)).minusSeconds(5L);
        return LocalDateTime.now().isAfter(expirationTime);
    }

    private boolean isNullOrEmpty(String ... values) {
        return Arrays.stream(values).anyMatch(value -> value == null || value.isEmpty());
    }

    private boolean isMissingOneToken(Map<String, Object> json) {
        return json.get("access_token") == null || json.get("refresh_token") == null;
    }

    private Object getTokenSynchronizer(Session session) {
        String refreshToken = session.getOAuth2AnswerParameters().getRefreshToken();
        try {
            return refreshToken == null ? new Object() : this.synchronizers.get((Object)refreshToken, Object::new);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

