/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client.rf.token;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Statistics;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.interceptor.oauth2client.rf.JsonUtils;
import com.predic8.membrane.core.interceptor.session.Session;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AccessTokenRevalidator {
    private final Cache<String, Boolean> validTokens = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private int revalidateTokenAfter = -1;
    private AuthorizationService auth;
    private OAuth2Statistics statistics;

    public void init(AuthorizationService auth, OAuth2Statistics statistics) {
        this.auth = auth;
        this.statistics = statistics;
    }

    public void revalidateIfNeeded(Session session, String wantedScope) throws Exception {
        if (!this.tokenNeedsRevalidation(session, wantedScope)) {
            return;
        }
        if (this.revalidate(session, this.statistics, wantedScope) == null) {
            session.clear();
        }
    }

    public Map<String, Object> revalidate(Session session, OAuth2Statistics statistics, String wantedScope) throws Exception {
        Response response = this.auth.requestUserEndpoint(session.getOAuth2AnswerParameters(wantedScope));
        if (response.getStatusCode() != 200) {
            statistics.accessTokenValid();
            return null;
        }
        statistics.accessTokenValid();
        if (!JsonUtils.isJson(response)) {
            throw new RuntimeException("Response is no JSON.");
        }
        return (Map)new ObjectMapper().readValue(response.getBodyAsStreamDecoded(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
    }

    private boolean tokenNeedsRevalidation(Session session, String wantedScope) {
        if (!session.hasOAuth2Answer(wantedScope) || this.revalidateTokenAfter < 0) {
            return false;
        }
        return this.validTokens.getIfPresent((Object)session.getAccessToken(wantedScope)) == null;
    }

    public Cache<String, Boolean> getValidTokens() {
        return this.validTokens;
    }

    public int getRevalidateTokenAfter() {
        return this.revalidateTokenAfter;
    }

    public void setRevalidateTokenAfter(int revalidateTokenAfter) {
        this.revalidateTokenAfter = revalidateTokenAfter;
    }
}

