/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client.rf.token;

import com.predic8.membrane.core.transport.ssl.PEMSupport;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

public class JWSSigner {
    private final Key key;
    private final X509Certificate certificate;

    public JWSSigner(Object pemObj, String pemBlock) throws IOException {
        this.key = this.convertKey(pemObj);
        this.certificate = PEMSupport.getInstance().parseCertificate(pemBlock);
    }

    private Key convertKey(Object pemObj) {
        if (pemObj instanceof Key) {
            Key k = (Key)pemObj;
            return k;
        }
        if (pemObj instanceof KeyPair) {
            KeyPair kp = (KeyPair)pemObj;
            return kp.getPrivate();
        }
        throw new IllegalArgumentException("Unsupported PEM type " + String.valueOf(pemObj.getClass()));
    }

    public String generateSignedJWS(JwtClaims claims) throws JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey(this.key);
        jws.setX509CertSha1ThumbprintHeaderValue(this.certificate);
        jws.setAlgorithmHeaderValue("RS256");
        jws.setHeader("typ", "JWT");
        return jws.getCompactSerialization();
    }

    public String signToCompactSerialization(String payload) throws JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(payload);
        jws.setKey(this.key);
        jws.setX509CertSha1ThumbprintHeaderValue(this.certificate);
        jws.setAlgorithmHeaderValue("RS256");
        jws.setHeader("typ", "JWT");
        return jws.getCompactSerialization();
    }
}

