/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2server;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.message.ErrorMessage;
import com.floreysoft.jmte.message.ParseException;
import com.floreysoft.jmte.token.Token;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.AccountBlocker;
import com.predic8.membrane.core.interceptor.authentication.session.LoginDialog;
import com.predic8.membrane.core.interceptor.authentication.session.TokenProvider;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.server.WebServerInterceptor;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.interceptor.session.SessionManager;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.util.URI;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginDialog2 {
    private static final Logger log = LoggerFactory.getLogger((String)LoginDialog.class.getName());
    private final String path;
    private final String message;
    private final boolean exposeUserCredentialsToSession;
    private URIFactory uriFactory;
    private final UserDataProvider userDataProvider;
    private final TokenProvider tokenProvider;
    private final SessionManager sessionManager;
    private final AccountBlocker accountBlocker;
    private final WebServerInterceptor wsi;

    public LoginDialog2(UserDataProvider userDataProvider, TokenProvider tokenProvider, SessionManager sessionManager, AccountBlocker accountBlocker, String dialogLocation, String path, boolean exposeUserCredentialsToSession, String message) {
        this.path = path;
        this.exposeUserCredentialsToSession = exposeUserCredentialsToSession;
        this.userDataProvider = userDataProvider;
        this.tokenProvider = tokenProvider;
        this.sessionManager = sessionManager;
        this.accountBlocker = accountBlocker;
        this.message = message;
        this.wsi = new WebServerInterceptor();
        this.wsi.setDocBase(dialogLocation);
    }

    public void init(Router router) throws Exception {
        this.uriFactory = router.getUriFactory();
        this.wsi.init(router);
        router.getResolverMap().resolve(ResolverMap.combine(router.getBaseLocation(), this.wsi.getDocBase(), "index.html")).close();
    }

    public boolean isLoginRequest(Exchange exc) {
        URI uri = this.uriFactory.createWithoutException(exc.getRequest().getUri());
        return uri.getPath().startsWith(this.path);
    }

    private void showPage(Exchange exc, int page, Object ... params) throws Exception {
        String target = StringUtils.defaultString((String)URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR).get("target"));
        exc.getDestinations().set(0, "/index.html");
        this.wsi.handleRequest(exc);
        Engine engine = new Engine();
        engine.setErrorHandler(new ErrorHandler(this){

            public void error(ErrorMessage arg0, Token arg1, Map<String, Object> arg2) throws ParseException {
                log.error(arg0.key);
            }

            public void error(ErrorMessage arg0, Token arg1) throws ParseException {
                log.error(arg0.key);
            }
        });
        ImmutableMap pages = ImmutableMap.builder().put((Object)0, (Object)"login").put((Object)1, (Object)"token").put((Object)2, (Object)"consent").build();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("action", StringEscapeUtils.escapeXml11((String)this.path) + String.valueOf(pages.get(page)));
        model.put("target", StringEscapeUtils.escapeXml11((String)target));
        model.put(pages.get(page).toString(), true);
        for (int i = 0; i < params.length; i += 2) {
            model.put((String)params[i], params[i + 1]);
        }
        exc.getResponse().setBodyContent(engine.transform(exc.getResponse().getBodyAsStringDecoded(), model).getBytes(StandardCharsets.UTF_8));
    }

    public void handleLoginRequest(Exchange exc) throws Exception {
        Session s = this.sessionManager.getSession(exc);
        String uri = exc.getRequest().getUri().substring(this.path.length() > 0 ? this.path.length() - 1 : 0);
        if (uri.indexOf(63) >= 0) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        exc.getDestinations().add(uri);
        switch (uri) {
            case "/logout": {
                if (s != null) {
                    s.clear();
                }
                exc.setResponse(Response.redirect(this.path, false).body("").build());
                break;
            }
            case "/consent": {
                if (exc.getRequest().getMethod().equals("POST")) {
                    this.processConsentPageResult(exc, s);
                    break;
                }
                this.showConsentPage(exc, s);
                break;
            }
            case "/login": {
                if (s == null || !s.isVerified()) {
                    if (exc.getRequest().getMethod().equals("POST")) {
                        Map<String, String> userAttributes;
                        Map<String, String> params = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
                        String username = params.get("username");
                        if (username == null) {
                            this.showPage(exc, 0, "error", "INVALID_PASSWORD");
                            return;
                        }
                        if (this.accountBlocker != null && this.accountBlocker.isBlocked(username)) {
                            this.showPage(exc, 0, "error", "ACCOUNT_BLOCKED");
                            return;
                        }
                        try {
                            userAttributes = this.userDataProvider.verify(params);
                        }
                        catch (NoSuchElementException e) {
                            ArrayList params2 = Lists.newArrayList((Object[])new String[]{"error", "INVALID_PASSWORD"});
                            if (this.accountBlocker != null && this.accountBlocker.fail(username)) {
                                params2.addAll(Lists.newArrayList((Object[])new String[]{"accountBlocked", "true"}));
                            }
                            this.showPage(exc, 0, params2.toArray());
                            return;
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                            this.showPage(exc, 0, "error", "INTERNAL_SERVER_ERROR");
                            return;
                        }
                        if (this.exposeUserCredentialsToSession) {
                            for (Map.Entry<String, String> param : params.entrySet()) {
                                if (userAttributes.containsKey(param.getKey())) continue;
                                userAttributes.put(param.getKey(), param.getValue());
                            }
                        }
                        if (this.tokenProvider != null) {
                            this.showPage(exc, 1, new Object[0]);
                        } else {
                            String target = params.get("target");
                            if (StringUtils.isEmpty((CharSequence)target)) {
                                target = "/";
                            }
                            exc.setResponse(Response.redirectWithout300(target).build());
                        }
                        Map<String, String> conv = s.get().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (m1, m2) -> m1));
                        if (this.tokenProvider != null) {
                            this.tokenProvider.requestToken(conv);
                        }
                        s.get().keySet().forEach(conv::remove);
                        conv.forEach((key, value) -> s.put((String)key, value));
                        s.authorize(username);
                        break;
                    }
                    this.showPage(exc, 0, new Object[0]);
                    break;
                }
                if (this.accountBlocker != null && this.accountBlocker.isBlocked((String)s.getUsername())) {
                    this.showPage(exc, 0, "error", "ACCOUNT_BLOCKED");
                    return;
                }
                if (exc.getRequest().getMethod().equals("POST")) {
                    String target;
                    String token = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR).get("token");
                    try {
                        if (this.tokenProvider != null) {
                            this.tokenProvider.verifyToken(s.get().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString(), (m1, m2) -> m1)), token);
                        }
                    }
                    catch (NoSuchElementException e) {
                        ArrayList params = Lists.newArrayList((Object[])new String[]{"error", "INVALID_TOKEN"});
                        if (this.accountBlocker != null && this.accountBlocker.fail((String)s.getUsername())) {
                            params.addAll(Lists.newArrayList((Object[])new String[]{"accountBlocked", "true"}));
                        }
                        s.clear();
                        this.showPage(exc, 0, params.toArray());
                        return;
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                        s.clear();
                        this.showPage(exc, 0, "error", "INTERNAL_SERVER_ERROR");
                        return;
                    }
                    if (this.accountBlocker != null) {
                        this.accountBlocker.unblock((String)s.getUsername());
                    }
                    if (StringUtils.isEmpty((CharSequence)(target = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR).get("target")))) {
                        target = "/";
                    }
                    if (this.message != null) {
                        exc.setResponse(Response.redirectWithout300(target, this.message).build());
                    } else {
                        exc.setResponse(Response.redirectWithout300(target).build());
                    }
                    s.authorize((String)s.getUsername());
                    break;
                }
                this.showPage(exc, 1, new Object[0]);
                break;
            }
            default: {
                this.wsi.handleRequest(exc);
            }
        }
    }

    private void processConsentPageResult(Exchange exc, Session s) throws Exception {
        this.removeConsentPageDataFromSession(s);
        this.putConsentInSession(exc, s);
        this.redirectAfterConsent(exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsentPageDataFromSession(Session s) {
        if (s == null) {
            return;
        }
        Session session = s;
        synchronized (session) {
            s.remove("product_name");
            s.remove("logo_url");
            s.remove("scope_descriptions");
            s.remove("claim_descriptions");
        }
    }

    private void redirectAfterConsent(Exchange exc) throws Exception {
        String target = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR).get("target");
        if (StringUtils.isEmpty((CharSequence)target)) {
            target = "/";
        }
        exc.setResponse(Response.redirectWithout300(target).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putConsentInSession(Exchange exc, Session s) throws Exception {
        if (s == null) {
            return;
        }
        Map<String, String> params = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        String consentResult = "false";
        if (params.get("consent").equals("Accept")) {
            consentResult = "true";
        }
        Session session = s;
        synchronized (session) {
            s.put("consent", consentResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showConsentPage(Exchange exc, Session s) throws Exception {
        if (s == null) {
            this.showPage(exc, 2, "product_name", null, "logo_url", null, "scopes", null, "claims", null);
            return;
        }
        Session session = s;
        synchronized (session) {
            String productName = (String)s.get("product_name");
            String logoUrl = (String)s.get("logo_url");
            Map<String, String> scopes = this.doubleStringArrayToMap(this.prepareScopesFromSession(s));
            Map<String, String> claims = this.doubleStringArrayToMap(this.prepareClaimsFromSession(s));
            this.showPage(exc, 2, "product_name", productName, "logo_url", logoUrl, "scopes", scopes, "claims", claims);
        }
    }

    private Map<String, String> doubleStringArrayToMap(String[] strings) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : strings) {
            String[] str = string.split(" ");
            for (int i = 2; i < str.length; ++i) {
                str[1] = str[1] + " " + str[i];
            }
            result.put(str[0], str[1]);
        }
        return result;
    }

    private String[] prepareClaimsFromSession(Session s) throws UnsupportedEncodingException {
        return this.prepareStringArray(this.decodeClaimsFromSession(s));
    }

    private String[] prepareScopesFromSession(Session s) throws UnsupportedEncodingException {
        return this.prepareStringArray(this.decodeScopesFromSession(s));
    }

    private String[] prepareStringArray(String[] array) {
        if (array[0].isEmpty()) {
            return new String[0];
        }
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        for (int i = 0; i < array.length; i += 2) {
            result.add((CallSite)((Object)(array[i] + ": " + array[i + 1])));
        }
        return result.toArray(new String[0]);
    }

    private String[] decodeClaimsFromSession(Session s) {
        if (s.get("claim_descriptions") != null) {
            String[] claims = ((String)s.get("claim_descriptions")).split(" ");
            for (int i = 0; i < claims.length; ++i) {
                claims[i] = OAuth2Util.urldecode(claims[i]);
            }
            return claims;
        }
        return new String[0];
    }

    private String[] decodeScopesFromSession(Session s) {
        if (s.get("scope_descriptions") != null) {
            String[] scopes = ((String)s.get("scope_descriptions")).split(" ");
            for (int i = 0; i < scopes.length; ++i) {
                scopes[i] = OAuth2Util.urldecode(scopes[i]);
            }
            return scopes;
        }
        return new String[0];
    }

    public Outcome redirectToLogin(Exchange exc) throws UnsupportedEncodingException {
        exc.setResponse(Response.redirect(this.path + "?target=" + URLEncoder.encode(exc.getOriginalRequestUri(), StandardCharsets.UTF_8), false).dontCache().body("").build());
        return Outcome.RETURN;
    }
}

